<?php if ( ! defined( 'ABSPATH' ) ) {
	die;
} // Cannot access directly.

/**
 * The Typography class.
 */
class BOP_Typography {

	/**
	 * Typography section metabox.
	 *
	 * @param string $prefix The metabox key.
	 * @return void
	 */
	public static function section( $prefix ) {
		BOP::createSection(
			$prefix,
			array(
				'title'           => esc_html__( 'Typography', 'bookify-pro' ),
				'icon'            => 'fas fa-font',
				'enqueue_webfont' => true,
				'fields'          => array(
					array(
						'id'         => 'section_title_typography',
						'type'       => 'typography',
						'title'      => esc_html__( 'Section Title', 'bookify-pro' ),
						'subtitle'   => esc_html__( 'Set item showcase section title font properties.', 'bookify-pro' ),
						'default'    => array(
							'color'              => '#444',
							'font-family'        => '',
							'font-weight'        => '',
							'subset'             => '',
							'font-size'          => '24',
							'tablet-font-size'   => '15',
							'mobile-font-size'   => '18',
							'line-height'        => '28',
							'tablet-line-height' => '24',
							'mobile-line-height' => '15',
							'letter-spacing'     => '0',
							'text-align'         => 'left',
							'text-transform'     => 'none',
							'type'               => '',
							'unit'               => 'px',
						),
						'dependency' => array( 'section_title', '==', 'true', 'all' ),
					),
					array(
						'id'          => 'thumb_archive_typography',
						'type'        => 'typography',
						'title'       => esc_html__( 'Thumb Archive', 'bookify-pro' ),
						'subtitle'    => esc_html__( 'Set thumb archive font properties.', 'bookify-pro' ),
						'hover_color' => true,
						'default'     => array(
							'color'              => '#111111',
							'hover_color'        => '#c27b7f',
							'font-family'        => '',
							'font-weight'        => '600',
							'subset'             => '',
							'font-size'          => '12',
							'tablet-font-size'   => '12',
							'mobile-font-size'   => '10',
							'line-height'        => '18',
							'tablet-line-height' => '18',
							'mobile-line-height' => '16',
							'letter-spacing'     => '0',
							'text-align'         => 'left',
							'text-transform'     => 'uppercase',
							'type'               => '',
							'unit'               => 'px',
						),
						'dependency'  => array( 'post_thumb_show|post_thumb_meta', '==|!=', 'true|none', 'all' ),
					),
					array(
						'id'          => 'post_title_typography',
						'type'        => 'typography',
						'title'       => esc_html__( 'Title', 'bookify-pro' ),
						'subtitle'    => esc_html__( 'Set title font properties.', 'bookify-pro' ),
						'hover_color' => true,
						'default'     => array(
							'color'              => '#111111',
							'hover_color'        => '#c27b7f',
							'font-family'        => '',
							'font-weight'        => '',
							'subset'             => '',
							'font-size'          => '22',
							'tablet-font-size'   => '18',
							'mobile-font-size'   => '16',
							'line-height'        => '24',
							'tablet-line-height' => '22',
							'mobile-line-height' => '15',
							'letter-spacing'     => '0',
							'text-align'         => 'left',
							'text-transform'     => 'none',
							'type'               => '',
							'unit'               => 'px',
						),
						'dependency'  => array( 'show_post_title', '==', 'true', 'all' ),
					),
					array(
						'id'          => 'post_subtitle_typography',
						'type'        => 'typography',
						'title'       => esc_html__( 'Subtitle', 'bookify-pro' ),
						'subtitle'    => esc_html__( 'Set subtitle font properties.', 'bookify-pro' ),
						'hover_color' => true,
						'default'     => array(
							'color'              => '#111111',
							'hover_color'        => '#c27b7f',
							'font-family'        => '',
							'font-weight'        => '',
							'subset'             => '',
							'font-size'          => '18',
							'tablet-font-size'   => '18',
							'mobile-font-size'   => '16',
							'line-height'        => '24',
							'tablet-line-height' => '22',
							'mobile-line-height' => '15',
							'letter-spacing'     => '0',
							'text-align'         => 'left',
							'text-transform'     => 'none',
							'type'               => '',
							'unit'               => 'px',
						),
						'dependency'  => array( 'show_post_subtitle', '==', 'true', 'all' ),
					),
					array(
						'id'          => 'post_meta_typography',
						'type'        => 'typography',
						'title'       => esc_html__( 'Meta Fields', 'bookify-pro' ),
						'subtitle'    => esc_html__( 'Set meta fields font properties.', 'bookify-pro' ),
						'hover_color' => true,
						'default'     => array(
							'color'              => '#111111',
							'hover_color'        => '#c27b7f',
							'font-family'        => '',
							'font-weight'        => '',
							'subset'             => '',
							'font-size'          => '16',
							'tablet-font-size'   => '14',
							'mobile-font-size'   => '12',
							'line-height'        => '22',
							'tablet-line-height' => '16',
							'mobile-line-height' => '16',
							'letter-spacing'     => '0',
							'text-align'         => 'left',
							'text-transform'     => 'none',
							'type'               => '',
							'unit'               => 'px',
						),
						'dependency'  => array( 'show_post_meta', '==', 'true', 'all' ),
					),
					array(
						'id'          => 'book_category',
						'type'        => 'typography',
						'title'       => esc_html__( 'Book Category', 'bookify-pro' ),
						'subtitle'    => esc_html__( 'Set meta fields font properties.', 'bookify-pro' ),
						'hover_color' => true,
						'default'     => array(
							'color'              => '#ffffff',
							'hover_color'        => '#ffffff',
							'font-family'        => '',
							'font-weight'        => '',
							'subset'             => '',
							'font-size'          => '13',
							'tablet-font-size'   => '14',
							'mobile-font-size'   => '12',
							'line-height'        => '22',
							'tablet-line-height' => '16',
							'mobile-line-height' => '16',
							'letter-spacing'     => '0',
							'text-align'         => 'left',
							'text-transform'     => 'none',
							'type'               => '',
							'unit'               => 'px',
						),
						'dependency'  => array( 'show_book_category', '==', 'true', 'all' ),
					),
					array(
						'id'          => 'book_fildes_typography',
						'type'        => 'typography',
						'title'       => esc_html__( 'Book Fields', 'bookify-pro' ),
						'subtitle'    => esc_html__( 'Set event fields font properties.', 'bookify-pro' ),
						'hover_color' => true,
						'default'     => array(
							'color'              => '#111111',
							'hover_color'        => '#c27b7f',
							'font-family'        => '',
							'font-weight'        => '',
							'subset'             => '',
							'font-size'          => '16',
							'tablet-font-size'   => '14',
							'mobile-font-size'   => '12',
							'line-height'        => '22',
							'tablet-line-height' => '18',
							'mobile-line-height' => '16',
							'letter-spacing'     => '0',
							'text-align'         => 'left',
							'text-transform'     => 'none',
							'type'               => '',
							'unit'               => 'px',
						),
						'dependency'  => array( 'show_book_fildes', '==', 'true', 'all' ),
					),
					array(
						'id'         => 'post_content_typography',
						'type'       => 'typography',
						'title'      => esc_html__( 'Content', 'bookify-pro' ),
						'subtitle'   => esc_html__( 'Set content font properties.', 'bookify-pro' ),
						'default'    => array(
							'color'              => '#111111',
							'font-family'        => '',
							'font-weight'        => '',
							'subset'             => '',
							'font-size'          => '16',
							'tablet-font-size'   => '14',
							'mobile-font-size'   => '12',
							'line-height'        => '22',
							'tablet-line-height' => '18',
							'mobile-line-height' => '18',
							'letter-spacing'     => '0',
							'text-align'         => 'left',
							'text-transform'     => 'none',
							'type'               => '',
							'unit'               => 'px',
						),
						'dependency' => array( 'show_post_content', '==', 'true', 'all' ),
					),
					array(
						'id'         => 'read_more_typography',
						'type'       => 'typography',
						'title'      => esc_html__( 'Read More', 'bookify-pro' ),
						'subtitle'   => esc_html__( 'Set read more font properties.', 'bookify-pro' ),
						'color'      => false,
						'default'    => array(
							'font-family'        => '',
							'font-weight'        => '600',
							'subset'             => '',
							'font-size'          => '12',
							'tablet-font-size'   => '12',
							'mobile-font-size'   => '10',
							'line-height'        => '18',
							'tablet-line-height' => '18',
							'mobile-line-height' => '16',
							'letter-spacing'     => '0',
							'text-align'         => 'left',
							'text-transform'     => 'uppercase',
							'type'               => '',
							'unit'               => 'px',
						),
						'dependency' => array( 'show_read_more', '==', 'true', 'all' ),
					),
					array(
						'id'         => 'buy_now_typography',
						'type'       => 'typography',
						'title'      => esc_html__( 'Buy Now', 'bookify-pro' ),
						'subtitle'   => esc_html__( 'Set buy now font properties.', 'bookify-pro' ),
						'color'      => false,
						'default'    => array(
							'font-family'        => '',
							'font-weight'        => '600',
							'subset'             => '',
							'font-size'          => '12',
							'tablet-font-size'   => '12',
							'mobile-font-size'   => '10',
							'line-height'        => '18',
							'tablet-line-height' => '18',
							'mobile-line-height' => '16',
							'letter-spacing'     => '0',
							'text-align'         => 'left',
							'text-transform'     => 'uppercase',
							'type'               => '',
							'unit'               => 'px',
						),
						'dependency' => array( 'show_bye_now_button', '==', 'true', 'all' ),
					),
					array(
						'id'       => 'custom_fields_typography',
						'type'     => 'typography',
						'title'    => esc_html__( 'Custom Fields', 'bookify-pro' ),
						'subtitle' => esc_html__( 'Set custom fields font properties.', 'bookify-pro' ),
						'default'  => array(
							'color'              => '#888',
							'font-family'        => '',
							'font-weight'        => '',
							'subset'             => '',
							'font-size'          => '14',
							'tablet-font-size'   => '14',
							'mobile-font-size'   => '12',
							'line-height'        => '18',
							'tablet-line-height' => '18',
							'mobile-line-height' => '16',
							'letter-spacing'     => '0',
							'text-align'         => 'left',
							'text-transform'     => 'none',
							'type'               => '',
							'unit'               => 'px',
						),
					),
				), // End of fields array.
			)
		);
	}
}
