<?php if ( ! defined( 'ABSPATH' ) ) {
	die;
} // Cannot access directly.

/**
 * The Layout building class.
 */
class BOP_Display {


	/**
	 * Display options section metabox.
	 *
	 * @param string $prefix The metabox key.
	 * @return void
	 */
	public static function section( $prefix ) {
		BOP::createSection(
			$prefix,
			array(
				'title'  => esc_html__( 'DISPLAY OPTIONS', 'bookify-pro' ),
				'icon'   => 'fas fa-th-large',
				'fields' => array(
					array(
						'id'         => 'section_title',
						'type'       => 'switcher',
						'title'      => esc_html__( 'Section Title ', 'bookify-pro' ),
						'subtitle'   => esc_html__( 'Show/Hide item showcase section title.', 'bookify-pro' ),
						'default'    => false,
						'text_on'    => esc_html__( 'Show', 'bookify-pro' ),
						'text_off'   => esc_html__( 'Hide', 'bookify-pro' ),
						'text_width' => 75,
					),
					array(
						'id'              => 'section_title_margin',
						'type'            => 'spacing',
						'title'           => esc_html__( 'Section Title Margin', 'bookify-pro' ),
						'subtitle'        => esc_html__( 'Set margin for the section title.', 'bookify-pro' ),
						'all_icon'        => '<i class="fas fa-long-arrow-down"></i>',
						'units'           => array(
							'px',
						),
						'all_placeholder' => 'margin',
						'default'         => array(
							'top'    => '0',
							'right'  => '0',
							'bottom' => '30',
							'left'   => '0',
						),
						'dependency'      => array(
							'section_title',
							'==',
							'true',
							true,
						),
					),
					array(
						'id'         => 'bop_number_of_columns',
						'type'       => 'column',
						'title'      => esc_html__( 'Column(s)', 'bookify-pro' ),
						'subtitle'   => esc_html__( 'Set number of column(s) in different devices for responsive view.', 'bookify-pro' ),
						'default'    => array(
							'lg_desktop'       => '3',
							'desktop'          => '3',
							'tablet'           => '2',
							'mobile_landscape' => '2',
							'mobile'           => '1',
						),
						'min'        => '1',
						'dependency' => array( 'bop_layout_preset', 'any', 'carousel_layout,grid_layout,filter_layout,large_with_small', true ),
						'help'       => wp_kses(
							esc_html__( '<i class="fas fa-tv"></i> <b> Large Desktop </b> - is larger than 1200px,<br><i class="fas fa-desktop"></i> <b>Desktop</b> - size is larger than 992px,<br> <i class="fas fa-tablet-alt"></i> <b>Tablet</b> - Size is larger than 768,<br> <i class="fas fa-mobile-alt"></i> <b> Mobile Landscape </b> - size is larger than 576px.,<br> <i class="fas fa-mobile-alt"></i> <b> Mobile </b> - size is smaller than 576px.', 'bookify-pro' ),
							array(
								'i'  => array( 'class' => array() ),
								'br' => array(),
							)
						),
					),
					array(
						'id'              => 'margin_between_post',
						'type'            => 'spacing',
						'title'           => esc_html__( 'Margin Between Columns', 'bookify-pro' ),
						'subtitle'        => esc_html__( 'Set margin between columns (items).', 'bookify-pro' ),
						'all'             => true,
						'all_icon'        => '<i class="fas fa-arrows-h"></i>',
						'units'           => array(
							'px',
						),
						'all_placeholder' => 'margin',
						'default'         => array(
							'all' => '20',
						),
					),
					array(
						'id'         => 'post_content_orientation',
						'type'       => 'layout_preset',
						'title'      => esc_html__( 'Content Orientation ', 'bookify-pro' ),
						'subtitle'   => esc_html__( 'Set a position for the item content.', 'bookify-pro' ),
						'desc'       => esc_html__( 'More amazing Content Orientation and Layout', 'bookify-pro' ),
						'class'      => 'bop-content-orientation',
						'options'    => array(
							'default' => array(
								'image' => BOP_URL . 'admin/views/ta-framework/assets/img/default.png',
								'text'  => esc_html__( 'Default', 'bookify-pro' ),
							),
							'overlay' => array(
								'image'    => BOP_URL . 'admin/views/ta-framework/assets/img/overlay.png',
								'text'     => esc_html__( 'Overlay', 'bookify-pro' ),
								'pro_only' => true,
							),
						),
						'default'    => 'default',
						'dependency' => array( 'bop_layout_preset', 'any', 'carousel_layout,grid_layout,filter_layout,large_with_small', true ),
					),
					array(
						'id'         => 'item_same_height',
						'type'       => 'checkbox',
						'title'      => esc_html__( 'Same Height', 'bookify-pro' ),
						'subtitle'   => esc_html__( 'Check to make all items/slides the same height as the tallest one.', 'bookify-pro' ),
						'default'    => false,
						'dependency' => array( 'bop_layout_preset', 'any', 'carousel_layout,grid_layout,filter_layout,large_with_small', true ),
					),
					array(
						'id'         => 'post_list_orientation',
						'type'       => 'layout_preset',
						'class'      => 'img_custom_width',
						'title'      => esc_html__( 'Content Orientation ', 'bookify-pro' ),
						'subtitle'   => esc_html__( 'Set a position for the post content.', 'bookify-pro' ),
						'options'    => array(
							'left-thumb'  => array(
								'image' => BOP_URL . 'admin/views/ta-framework/assets/img/left-image.svg',
								'text'  => esc_html__( 'Left Image', 'bookify-pro' ),
							),
							'right-thumb' => array(
								'image' => BOP_URL . 'admin/views/ta-framework/assets/img/right-image.svg',
								'text'  => esc_html__( 'Right Image', 'bookify-pro' ),
							),
						),
						'default'    => 'left-thumb',
						'dependency' => array( 'bop_layout_preset', '==', 'list_layout', true ),
					),
					array(
						'id'       => 'post_border',
						'type'     => 'border',
						'title'    => esc_html__( 'Border', 'bookify-pro' ),
						'subtitle' => esc_html__( 'Set border for the item.', 'bookify-pro' ),
						'all'      => true,
						'default'  => array(
							'all'   => '0',
							'style' => 'solid',
							'color' => '#e2e2e2',
						),
					),
					array(
						'id'       => 'post_border_radius_property',
						'type'     => 'spacing',
						'title'    => esc_html__( 'Border Radius', 'bookify-pro' ),
						'subtitle' => esc_html__( 'Set border radius for item.', 'bookify-pro' ),
						'all'      => true,
						'units'    => array( 'px', '%' ),
						'default'  => array(
							'all' => '0',
						),
					),
					array(
						'id'       => 'show_post_box_shadow',
						'type'     => 'checkbox',
						'title'    => esc_html__( 'Box-Shadow', 'bookify-pro' ),
						'subtitle' => esc_html__( 'Show box-shadow for the item.', 'bookify-pro' ),
						'default'  => false,
					),
					array(
						'id'         => 'post_box_shadow_property',
						'type'       => 'box_shadow',
						'title'      => esc_html__( 'Box-Shadow Values', 'bookify-pro' ),
						'subtitle'   => esc_html__( 'Set box-shadow property values for the item.', 'bookify-pro' ),
						'default'    => array(
							'horizontal' => '0',
							'vertical'   => '0',
							'blur'       => '8',
							'spread'     => '-2',
							'color'      => 'rgb(187, 187, 187)',
						),
						'dependency' => array( 'show_post_box_shadow', '==', 'true' ),
					),
					array(
						'id'         => 'post_background_property',
						'type'       => 'color',
						'title'      => esc_html__( 'Background', 'bookify-pro' ),
						'subtitle'   => esc_html__( 'Set background color for the item.', 'bookify-pro' ),
						'default'    => 'transparent',
						'dependency' => array( 'post_content_orientation', '!=', 'overlay' ),
					),
					array(
						'id'         => 'post_background_overlay',
						'type'       => 'color',
						'title'      => esc_html__( 'Background', 'bookify-pro' ),
						'subtitle'   => esc_html__( 'Set background color for the item. test', 'bookify-pro' ),
						'default'    => '#14141F',
						'dependency' => array( 'post_content_orientation', '==', 'overlay' ),
					),
					array(
						'id'         => 'post_background_blur',
						'type'       => 'slider',
						'title'      => esc_html__( 'Slider', 'bookify-pro' ),
						'min'        => 0,
						'max'        => 9,
						'step'       => 1,
						'unit'       => '',
						'default'    => 7,
						'dependency' => array( 'post_content_orientation', '==', 'overlay' ),
					),

					array(
						'id'       => 'post_inner_padding_property',
						'type'     => 'spacing',
						'title'    => esc_html__( 'Inner Padding', 'bookify-pro' ),
						'subtitle' => esc_html__( 'Set inner padding for  item.', 'bookify-pro' ),
						'default'  => array(
							'top'    => '0',
							'right'  => '0',
							'bottom' => '0',
							'left'   => '0',
							'unit'   => 'px',
						),
						'help'     => "<img src='" . BOP_URL . "/admin/assets/img/inner_padding.jpg'>",
					),
					array(
						'id'       => 'post_content_sorter',
						'type'     => 'sortable',
						'title'    => esc_html__( 'Content Fields', 'bookify-pro' ),
						'subtitle' => esc_html__( 'Item content fields which are draggable to change display order and it\'s settings.', 'bookify-pro' ),
						'class'    => 'post_content_sorter',
						'fields'   => array(
							array(
								'id'         => 'bop_post_thumb',
								'type'       => 'accordion',
								'accordions' => array(
									array(
										'title'  => esc_html__( 'Thumbnail', 'bookify-pro' ),
										'fields' => array(
											array(
												'id'       => 'post_thumb_show',
												'type'     => 'switcher',
												'title'    => esc_html__( 'Thumbnail', 'bookify-pro' ),
												'text_on'  => esc_html__( 'Show', 'bookify-pro' ),
												'text_off' => esc_html__( 'Hide', 'bookify-pro' ),
												'default'  => true,
												'text_width' => 80,
											),
											array(
												'id'      => 'bop_thumb_sizes',
												'type'    => 'image_sizes',
												'title'   => esc_html__( 'Size', 'bookify-pro' ),
												'default' => 'full',
												'dependency' => array( 'post_thumb_show', '==', 'true', true ),
											),
											array(
												'id'       => 'bop_image_crop_size',
												'type'     => 'dimensions_advanced',
												'title'    => esc_html__( 'Custom Size', 'bookify-pro' ),
												'chosen'   => true,
												'bottom'   => false,
												'left'     => false,
												'color'    => false,
												'top_icon' => '<i class="fas fa-arrows-h"></i>',
												'right_icon' => '<i class="fas fa-arrows-v"></i>',
												'top_placeholder' => esc_html('width', 'bookify-pro'),
												'right_placeholder' => esc_html('height', 'bookify-pro'),
												'styles'   => array(
													'Soft-crop',
													'Hard-crop',
												),
												'default'  => array(
													'top'  => '600',
													'right' => '400',
													'style' => esc_html__( 'Soft-crop', 'bookify-pro' ),
													'unit' => 'px',
												),
												'attributes' => array(
													'min' => 0,
												),
												'dependency' => array( 'post_thumb_show|bop_thumb_sizes', '==|==', 'true|custom' ),
											),
											array(
												'id'       => 'load_2x_image',
												'type'     => 'switcher',
												'title'    => esc_html__( 'Load 2x Resolution Image in Retina Display', 'bookify-pro' ),
												'text_on'  => esc_html__( 'Enabled', 'bookify-pro' ),
												'text_off' => esc_html__( 'Disabled', 'bookify-pro' ),
												'text_width' => 94,
												'default'  => false,
												'dependency' => array( 'post_thumb_show|bop_thumb_sizes', '==|==', 'true|custom' ),
											),
											array(
												'id'       => 'post_thumb_margin',
												'type'     => 'spacing',
												'title'    => esc_html__( 'Margin', 'bookify-pro' ),
												'sanitize' => 'bop_sanitize_number_array_field',
												'units'    => array( 'px' ),
												'min'      => -100,
												'default'  => array(
													'top'  => '0',
													'right' => '0',
													'bottom' => '15',
													'left' => '0',
												),
												'dependency' => array( 'post_thumb_show', '==', 'true' ),
											),
											array(
												'id'      => 'bop_thumb_src_replace',
												'type'    => 'checkbox',
												'title'   => esc_html__( 'Replace With', 'bookify-pro' ),
												'class'   => 'custom_help_text',
												'title_help' => esc_html__( 'This option will replace your default/featured post image with first resource ( image/video/audio ) from the content.', 'bookify-pro' ),
												'options' => array(
													'image'   => esc_html__( 'Image', 'bookify-pro' ),
													'video'   => esc_html__( 'Video', 'bookify-pro' ),
													'audio'   => esc_html__( 'Audio', 'bookify-pro' ),
												),
												'dependency' => array( 'post_thumb_show', '==', 'true' ),
											),
											array(
												'id'      => 'post_featured_thumb_found',
												'type'    => 'select',
												'title'   => ' ',
												'options' => array(
													'no_featured_img_found' => esc_html__( 'If no featured image found', 'bookify-pro' ),
													'even_featured_img_found' => esc_html__( 'Even featured image was found', 'bookify-pro' ),
												),
												'default' => 'no_featured_img_found',
												'dependency' => array( 'post_thumb_show|bop_thumb_src_replace', '==|any', 'true|image,video,audio' ),
											),

											array(
												'id'      => 'bop_thumb_border',
												'type'    => 'border',
												'title'   => esc_html__( 'Border', 'bookify-pro' ),
												'all'     => true,
												'default' => array(
													'all' => '0',
													'style' => 'solid',
													'color' => '#dddddd',
												),
												'dependency' => array( 'post_thumb_show', '==', 'true' ),
											),
											array(
												'id'       => 'post_thumb_border_radius',
												'type'     => 'spacing',
												'title'    => esc_html__( 'Border Radius', 'bookify-pro' ),
												'sanitize' => 'bop_sanitize_number_array_field',
												'default'  => array(
													'top'  => '0',
													'right' => '0',
													'bottom' => '0',
													'left' => '0',
													'unit' => 'px',
												),
												'dependency' => array( 'post_thumb_show', '==', 'true' ),
											),

											array(
												'id'      => 'post_thumb_zoom',
												'type'    => 'select',
												'title'   => esc_html__( 'Zoom Effect', 'bookify-pro' ),
												'options' => array(
													'none' => esc_html__( 'None', 'bookify-pro' ),
													'zoom_in' => esc_html__( 'Zoom In', 'bookify-pro' ),
													'zoom_out' => esc_html__( 'Zoom Out', 'bookify-pro' ),
												),
												'default' => 'none',
												'dependency' => array( 'post_thumb_show', '==', 'true' ),
											),
											array(
												'id'      => 'post_thumb_gray_scale',
												'type'    => 'select',
												'title'   => esc_html__( 'Image Mode', 'bookify-pro' ),
												'options' => array(
													'none' => esc_html__( 'Normal', 'bookify-pro' ),
													'gray_and_normal' => esc_html__( 'Grayscale and normal on hover', 'bookify-pro' ),
													'gray_on_hover' => esc_html__( 'Grayscale on hover', 'bookify-pro' ),
													'always_gray' => esc_html__( 'Always grayscale', 'bookify-pro' ),
												),
												'default' => 'none',
												'dependency' => array( 'post_thumb_show', '==', 'true' ),
											),
											array(
												'id'       => 'bop_img_lazy_load',
												'type'     => 'switcher',
												'class'    => 'custom_help_text',
												'title'    => esc_html__( 'Lazy Load', 'bookify-pro' ),
												'title_help' => esc_html__( 'Defer image loading to improve performance.', 'bookify-pro' ),
												'default'  => true,
												'text_on'  => esc_html__( 'Enabled', 'bookify-pro' ),
												'text_off' => esc_html__( 'Disabled', 'bookify-pro' ),
												'text_width' => 100,
												'dependency' => array( 'post_thumb_show|bop_layout_preset', '==|!=', 'true|carousel_layout', true ),
											),
											array(
												'id'      => 'post_thumb_meta',
												'type'    => 'button_set',
												'title'   => esc_html__( 'Show Post Thumb Meta', 'bookify-pro' ),
												'options' => array(
													'category' => esc_html__( 'Category', 'bookify-pro' ),
													'date' => esc_html__( 'Date', 'bookify-pro' ),
													'none' => esc_html__( 'None', 'bookify-pro' ),
												),
												'default' => 'none',
												'dependency' => array( 'post_thumb_show', '==', 'true' ),
											),
											array(
												'id'      => 'post_thumb_meta_taxonomy',
												'type'    => 'select',
												'title'   => esc_html__( 'Select Taxonomy', 'bookify-pro' ),
												'options' => 'taxonomy',
												'query_args' => array(
													'type' => 'bookify',
												),
												'attributes' => array(
													'style' => 'width: 200px;',
												),
												'empty_message' => esc_html__( 'No taxonomies found.', 'bookify-pro' ),
												'dependency' => array( 'post_thumb_show|post_thumb_meta', '==|==', 'true|category' ),
											),
											array(
												'id'      => 'post_thumb_meta_date_format',
												'type'    => 'select',
												'title'   => esc_html__( 'Date Format', 'bookify-pro' ),
												'options' => array(
													'default' => esc_html__( 'Default', 'bookify-pro' ),
													'time_ago' => esc_html__( 'Time ago(human time)', 'bookify-pro' ),
													'custom' => esc_html__( 'Custom', 'bookify-pro' ),
												),
												'default' => 'default',
												'dependency' => array( 'select_post_meta', '==', 'date' ),
											),
											array(
												'id'       => 'post_thumb_meta_position',
												'type'     => 'select',
												'title'    => esc_html__( 'Taxonomy Position', 'bookify-pro' ),
												'subtitle' => esc_html__( 'Select a position for the navigation arrows.', 'bookify-pro' ),
												'options'  => array(
													'top_right'                   => esc_html__( 'Top right', 'bookify-pro' ),
													'top_center'                  => esc_html__( 'Top center', 'bookify-pro' ),
													'top_left'                    => esc_html__( 'Top left', 'bookify-pro' ),
													'bottom_left'                 => esc_html__( 'Bottom left', 'bookify-pro' ),
													'bottom_center'               => esc_html__( 'Bottom center', 'bookify-pro' ),
													'bottom_right'                => esc_html__( 'Bottom right', 'bookify-pro' ),
												),
												'default'  => 'top_right',
												'dependency' => array( 'post_thumb_show|post_thumb_meta', '==|!=', 'true|none' ),
											),
											array(
												'id'      => 'post_thumb_meta_button',
												'type'    => 'color_group',
												'title'   => esc_html__( 'Read More Color', 'bookify-pro' ),
												'options' => array(
													'standard' => esc_html__( 'Text Color', 'bookify-pro' ),
													'hover' => esc_html__( 'Text Hover Color', 'bookify-pro' ),
													'bg' => esc_html__( 'Background', 'bookify-pro' ),
													'hover_bg' => esc_html__( 'Hover Background', 'bookify-pro' ),
													'border' => esc_html__( 'Border', 'bookify-pro' ),
													'hover_border' => esc_html__( 'Hover Border', 'bookify-pro' ),
												),
												'default' => array(
													'standard' => '#ffffff',
													'hover' => '#ffffff',
													'bg' => '#c27b7f',
													'hover_bg' => '#876585',
													'border' => '#c27b7f',
													'hover_border' => '#876585',
												),
												'dependency' => array( 'post_thumb_show|post_thumb_meta', '==|!=', 'true|none' ),
											),
										),
									),
								),
							),
							array(
								'id'         => 'bop_post_title',
								'type'       => 'accordion',
								'accordions' => array(
									array(
										'title'  => esc_html__( 'Title', 'bookify-pro' ),
										'fields' => array(
											array(
												'id'       => 'show_post_title',
												'type'     => 'switcher',
												'title'    => esc_html__( 'Title', 'bookify-pro' ),
												'text_on'  => esc_html__( 'Show', 'bookify-pro' ),
												'text_off' => esc_html__( 'Hide', 'bookify-pro' ),
												'default'  => true,
												'text_width' => 80,
											),
											array(
												'id'      => 'post_title_tag',
												'type'    => 'select',
												'title'   => esc_html__( 'Title HTML Tag', 'bookify-pro' ),
												'options' => array(
													'h1'  => esc_html__( 'h1', 'bookify-pro' ),
													'h2'  => esc_html__( 'h2', 'bookify-pro' ),
													'h3'  => esc_html__( 'h3', 'bookify-pro' ),
													'h4'  => esc_html__( 'h4', 'bookify-pro' ),
													'h5'  => esc_html__( 'h5', 'bookify-pro' ),
													'h6'  => esc_html__( 'h6', 'bookify-pro' ),
													'p'   => esc_html__( 'p', 'bookify-pro' ),
													'div' => esc_html__( 'div', 'bookify-pro' ),
												),
												'default' => 'h2',
												'class'   => 'chosen',
												'dependency' => array( 'show_post_title', '==', 'true', true ),
											),
											array(
												'id'      => 'post_title_limit',
												'type'    => 'checkbox',
												'title'   => esc_html__( 'Limit Character', 'bookify-pro' ),
												'default' => false,
												'dependency' => array( 'show_post_title', '==', 'true' ),
											),
											array(
												'id'       => 'bop_title_length',
												'type'     => 'spinner',
												'title'    => esc_html__( 'Length', 'bookify-pro' ),
												'default'  => '30',
												'sanitize' => 'bop_sanitize_number_field',
												'unit'     => esc_html__( 'chars', 'bookify-pro' ),
												'dependency' => array( 'post_title_limit|show_post_title', '==|==', 'true|true' ),
											),
											array(
												'id'       => 'post_title_margin',
												'type'     => 'spacing',
												'title'    => esc_html__( 'Margin', 'bookify-pro' ),
												'sanitize' => 'bop_sanitize_number_array_field',
												'min'      => -100,
												'units'    => array( 'px' ),
												'default'  => array(
													'top'  => '0',
													'right' => '0',
													'bottom' => '15',
													'left' => '0',
												),
												'dependency' => array( 'show_post_title', '==', 'true' ),
											),
										),
									),
								),
							),
							array(
								'id'         => 'bop_post_subtitle',
								'type'       => 'accordion',
								'accordions' => array(
									array(
										'title'  => esc_html__( 'Subtitle', 'bookify-pro' ),
										'fields' => array(
											array(
												'id'       => 'show_post_subtitle',
												'type'     => 'switcher',
												'title'    => esc_html__( 'Subtitle', 'bookify-pro' ),
												'text_on'  => esc_html__( 'Show', 'bookify-pro' ),
												'text_off' => esc_html__( 'Hide', 'bookify-pro' ),
												'default'  => true,
												'text_width' => 80,
											),
											array(
												'id'      => 'post_subtitle_tag',
												'type'    => 'select',
												'title'   => esc_html__( 'Subtitle HTML Tag', 'bookify-pro' ),
												'options' => array(
													'h1'  => esc_html__( 'h1', 'bookify-pro' ),
													'h2'  => esc_html__( 'h2', 'bookify-pro' ),
													'h3'  => esc_html__( 'h3', 'bookify-pro' ),
													'h4'  => esc_html__( 'h4', 'bookify-pro' ),
													'h5'  => esc_html__( 'h5', 'bookify-pro' ),
													'h6'  => esc_html__( 'h6', 'bookify-pro' ),
													'p'   => esc_html__( 'p', 'bookify-pro' ),
													'div' => esc_html__( 'div', 'bookify-pro' ),
												),
												'default' => 'h4',
												'class'   => 'chosen',
												'dependency' => array( 'show_post_subtitle', '==', 'true', true ),
											),
											array(
												'id'      => 'post_subtitle_limit',
												'type'    => 'checkbox',
												'title'   => esc_html__( 'Limit Character', 'bookify-pro' ),
												'default' => false,
												'dependency' => array( 'show_post_title', '==', 'true' ),
											),
											array(
												'id'       => 'bop_subtitle_length',
												'type'     => 'spinner',
												'title'    => esc_html__( 'Length', 'bookify-pro' ),
												'default'  => '30',
												'sanitize' => 'bop_sanitize_number_field',
												'unit'     => esc_html__( 'chars', 'bookify-pro' ),
												'dependency' => array( 'post_subtitle_limit|show_post_subtitle', '==|==', 'true|true' ),
											),
											array(
												'id'       => 'post_subtitle_margin',
												'type'     => 'spacing',
												'title'    => esc_html__( 'Margin', 'bookify-pro' ),
												'sanitize' => 'bop_sanitize_number_array_field',
												'min'      => -100,
												'units'    => array( 'px' ),
												'default'  => array(
													'top'  => '0',
													'right' => '0',
													'bottom' => '15',
													'left' => '0',
												),
												'dependency' => array( 'show_post_subtitle', '==', 'true' ),
											),
										),
									),
								),
							),

							array(
								'id'         => 'bop_post_meta',
								'class'      => 'bop_post_meta ta-product-not-fields',
								'type'       => 'accordion',
								'accordions' => array(
									array(
										'title'  => esc_html__( 'Meta Fields', 'bookify-pro' ),
										'fields' => array(
											array(
												'id'       => 'show_post_meta',
												'type'     => 'switcher',
												'title'    => esc_html__( 'Meta Fields', 'bookify-pro' ),
												'text_on'  => esc_html__( 'Show', 'bookify-pro' ),
												'text_off' => esc_html__( 'Hide', 'bookify-pro' ),
												'default'  => true,
												'text_width' => 80,
											),
											array(
												'id'      => 'bop_post_meta_group',
												'class'   => 'bop_custom_group_design',
												'type'    => 'group',
												'button_title' => esc_html__( 'Add New Meta', 'bookify-pro' ),
												'dependency' => array( 'show_post_meta', '==', 'true' ),
												'fields'  => array(
													array(
														'id'       => 'select_post_meta',
														'class'       => 'select_post_meta',
														'type'     => 'select',
														'title'    => esc_html__( 'Select Meta', 'bookify-pro' ),
														'placeholder' => esc_html__( 'Select a meta', 'bookify-pro' ),
														'options'  => array(
															'author'  => esc_html__( 'Author', 'bookify-pro' ),
															'date'   => esc_html__( 'Date', 'bookify-pro' ),
															'taxonomy'   => esc_html__( 'Taxonomy', 'bookify-pro' ),
															'view_count' => esc_html__( 'View Count', 'bookify-pro' ),
															'like'     => esc_html__( 'Like', 'bookify-pro' ),
															'reading_time'     => esc_html__( 'Reading Time', 'bookify-pro' ),
														),
													),
													array(
														'id'      => 'post_meta_author_avatar',
														'type'    => 'select',
														'title'   => esc_html__( 'Avatar', 'bookify-pro' ),
														'class'   => 'post_meta_author_avatar',
														'options' => array(
															'show_name' => esc_html__( 'Show name', 'bookify-pro' ),
															'show_gravatar' => esc_html__( 'Show gravatar', 'bookify-pro' ),
															'name_with_gravatar' => esc_html__( 'Author name & gravatar', 'bookify-pro' ),
															'name_with_icon' => esc_html__( 'Author name with an icon', 'bookify-pro' ),

														),
														'desc' => esc_html__( 'To show gravatar, you must <a href="https://wordpress.org/support/article/how-to-use-gravatars/" target="_blank" rel="noopener noreferrer nofollow"><em>enable it</em></a>.', 'bookify-pro' ),
														'default' => 'name_with_icon',
														'dependency' => array( 'select_post_meta', '==', 'author' ),
													),
													array(
														'id'      => 'post_meta_date_format',
														'type'    => 'select',
														'title'   => esc_html__( 'Date Format', 'bookify-pro' ),
														'class'   => 'post_meta_date_format',
														'options' => array(
															'default' => esc_html__( 'Default', 'bookify-pro' ),
															'time_ago' => esc_html__( 'Time ago(human time)', 'bookify-pro' ),
															'custom' => esc_html__( 'Custom', 'bookify-pro' ),
														),
														'default' => 'default',
														'dependency' => array( 'select_post_meta', '==', 'date' ),
													),
													array(
														'id'    => 'bop_custom_meta_date_format',
														'type'  => 'text',
														'title' => ' ',
														'class' => 'bop_custom_meta_date_format',
														'placeholder' => esc_html__( 'F j, Y', 'bookify-pro' ),
														'default'   => esc_html__( 'F j, Y', 'bookify-pro' ),
														'desc' => __( 'To define format, check <a href="https://wordpress.org/support/article/formatting-date-and-time/" target="_blank" rel="noopener noreferrer nofollow"><em>this doc</em></a>.', 'bookify-pro' ),
														'dependency' => array( 'select_post_meta|post_meta_date_format', '==|==', 'date|custom' ),
													),
													array(
														'id'      => 'post_meta_taxonomy',
														'type'    => 'select',
														'title'   => esc_html__( 'Select Taxonomy', 'bookify-pro' ),
														'class'   => 'post_meta_taxonomy',
														'options' => 'taxonomy',
														'query_args' => array(
															'type' => 'post',
														),
														'attributes' => array(
															'style' => 'width: 200px;',
														),
														'empty_message' => esc_html__( 'No taxonomies found.', 'bookify-pro' ),
														'dependency' => array( 'select_post_meta', '==', 'taxonomy' ),
													),
													array(
														'id'      => 'bop_meta_position',
														'class'      => 'bop_meta_position',
														'type'    => 'button_set',
														'title'   => esc_html__( 'Position', 'bookify-pro' ),
														'options' => array(
															'beside_meta' => esc_html__( 'Beside Other Meta', 'bookify-pro' ),
															'above_title' => esc_html__( 'Above Title', 'bookify-pro' ),
															'over_thumb' => esc_html__( 'Over Thumbnail', 'bookify-pro' ),

														),
														'default' => 'beside_meta',
														'dependency' => array( 'select_post_meta', '==', 'taxonomy' ),
													),
													array(
														'id'      => 'bop_meta_over_thump_position',
														'type'    => 'select',
														'title'   => esc_html__( 'Over Thumbnail Position', 'bookify-pro' ),
														'options' => array(
															'top_left' => esc_html__( 'Top Left', 'bookify-pro' ),
															'top_right' => esc_html__( 'Top Right', 'bookify-pro' ),
															'bottom_left' => esc_html__( 'Bottom Left', 'bookify-pro' ),
															'bottom_right' => esc_html__( 'Bottom Right', 'bookify-pro' ),
														),
														'default' => 'top_left',
														'dependency' => array( 'select_post_meta|bop_meta_position', '==|==', 'taxonomy|over_thumb' ),
													),
													array(
														'id'      => 'bop_meta_pill_color',
														'type'    => 'color_group',
														'title'   => esc_html__( 'Meta Color', 'bookify-pro' ),
														'options' => array(
															'text' => esc_html__( 'Text', 'bookify-pro' ),
															'bg' => esc_html__( 'Background', 'bookify-pro' ),
														),
														'default' => array(
															'text' => '#fff',
															'bg' => '#e53935',
														),
														'dependency' => array( 'select_post_meta|bop_meta_position', '==|!=', 'taxonomy|beside_meta' ),
													),
													array(
														'id'      => 'bop_word_per_minute',
														'type'    => 'number',
														'title'   => esc_html__( 'Per Minute', 'bookify-pro' ),
														'class'   => 'bop_reading_time_meta',
														'title_help'   => esc_html__( 'Default 300 words, the average reading speed for adults.', 'bookify-pro' ),
														'sanitize'        => 'bop_sanitize_number_field',
														'unit'   => esc_html__( 'words', 'bookify-pro' ),
														'default' => '300',
														'dependency' => array( 'select_post_meta', '==', 'reading_time' ),
													),
													array(
														'id'      => 'select_meta_icon',
														'class'      => 'select_meta_icon',
														'type'    => 'icon',
														'title'   => esc_html__( 'Meta Icon', 'bookify-pro' ),
														'default' => 'far fa-folder',
														'dependency' => array( 'bop_meta_position|select_post_meta', '==|!=', 'beside_meta|like' ),
													),
													array(
														'id'      => 'reading_time_postfix',
														'type'    => 'text',
														'title'   => esc_html__( 'Reading Time Postfix', 'bookify-pro' ),
														'class'   => 'bop_reading_time_postfix',
														'title_help'   => esc_html__( 'Text after time. Leave empty for nothing.', 'bookify-pro' ),
														'default' => esc_html__( ' Min Read', 'bookify-pro' ),
														'dependency' => array( 'select_post_meta', '==', 'reading_time' ),
													),
												),
												'default' => array(
													array(
														'select_post_meta'    => 'author',
														'post_meta_author_avatar'    => 'name_with_icon',
														'select_meta_icon'    => 'fas fa-user',
														'bop_meta_position'     => 'beside_meta',
													),
													array(
														'select_post_meta'     => 'date',
														'select_meta_icon'    => 'fas fa-calendar',
														'bop_meta_position'     => 'beside_meta',
													),
												),
											),
											array(
												'id'      => 'meta_separator',
												'type'    => 'radio',
												'title'   => esc_html__( 'Meta Separator', 'bookify-pro' ),
												'options' => array(
													' '  => esc_html__( 'Normal Space ', 'bookify-pro' ),
													'. ' => esc_html__( 'Full Stop ( . ) ', 'bookify-pro' ),
													'| ' => esc_html__( 'Straight Line ( | )', 'bookify-pro' ),
													'/ ' => esc_html__( 'Slash ( / )', 'bookify-pro' ),
													'\ ' => esc_html__( 'Back Slash( \\ )', 'bookify-pro' ),
												),
												'default' => ' ',
												'dependency' => array( 'show_post_meta', '==', 'true' ),
											),
											array(
												'id'      => 'meta_separator_color',
												'type'    => 'color',
												'title'   => esc_html__( 'Meta Separator Color', 'bookify-pro' ),
												'default' => '#c27b7f',
												'dependency' => array( 'show_post_meta', '==', 'true' ),
											),
											array(
												'id'      => 'post_meta_alignment',
												'type'    => 'button_set',
												'title'   => esc_html__( 'Alignment', 'bookify-pro' ),
												'options' => array(
													'left' => wp_kses( __( '<i class="fas fa-align-left" title="Left"></i>', 'bookify-pro' ), array( 'i' => array( 'class' => array() ) ) ),
													'center' => wp_kses( __( '<i class="fas fa-align-center" title="Center"></i>', 'bookify-pro' ), array( 'i' => array( 'class' => array() ) ) ),
													'right' => wp_kses( __( '<i class="fas fa-align-right" title="Right"></i>', 'bookify-pro' ), array( 'i' => array( 'class' => array() ) ) ),
												),
												'default' => 'left',
												'dependency' => array( 'show_post_meta', '==', 'true' ),
											),
											array(
												'id'       => 'post_meta_margin',
												'type'     => 'spacing',
												'title'    => esc_html__( 'Margin', 'bookify-pro' ),
												'sanitize' => 'bop_sanitize_number_array_field',
												'units'    => array( 'px' ),
												'min'      => -100,
												'dependency' => array( 'show_post_meta', '==', 'true' ),
												'default'  => array(
													'top'  => '0',
													'right' => '0',
													'bottom' => '15',
													'left' => '0',
												),
											),
											array(
												'id'       => 'post_meta_between_margin',
												'type'     => 'spacing',
												'title'    => esc_html__( 'Margin Between Post Meta', 'bookify-pro' ),
												'sanitize' => 'bop_sanitize_number_array_field',
												'units'    => array( 'px' ),
												'min'      => -5,
												'dependency' => array( 'show_post_meta', '==', 'true' ),
												'default'  => array(
													'top'  => '0',
													'right' => '0',
													'bottom' => '0',
													'left' => '0',
												),
											),
										),
									),
								),
							),
							array(
								'id'         => 'bop_book_category',
								'type'       => 'accordion',
								'accordions' => array(
									array(
										'title'  => esc_html__( 'Category', 'bookify-pro' ),
										'fields' => array(
											array(
												'id'       => 'show_book_category',
												'type'     => 'switcher',
												'title'    => esc_html__( 'Book Category', 'bookify-pro' ),
												'text_on'  => esc_html__( 'Show', 'bookify-pro' ),
												'text_off' => esc_html__( 'Hide', 'bookify-pro' ),
												'default'  => true,
												'text_width' => 80,
											),
											array(
												'id'      => 'bop_book_category_taxonomy',
												'type'    => 'select',
												'title'   => esc_html__( 'Select Taxonomy', 'bookify-pro' ),
												'options' => 'taxonomy',
												'query_args' => array(
													'type' => 'bookify',
												),
												'attributes' => array(
													'style' => 'width: 200px;',
												),
												'empty_message' => esc_html__( 'No taxonomies found.', 'bookify-pro' ),
												'dependency' => array( 'show_book_category', '==', 'true' ),
											),
											array(
												'id'      => 'bop_book_category_bg',
												'type'    => 'color_group',
												'title'   => esc_html__( 'Category Color', 'bookify-pro' ),
												'options' => array(
													'standard' => esc_html__( 'Text Color', 'bookify-pro' ),
													'hover' => esc_html__( 'Text Hover Color', 'bookify-pro' ),
													'bg' => esc_html__( 'Background', 'bookify-pro' ),
													'hover_bg' => esc_html__( 'Hover Background', 'bookify-pro' ),
													'border' => esc_html__( 'Border', 'bookify-pro' ),
													'hover_border' => esc_html__( 'Hover Border', 'bookify-pro' ),
												),
												'default' => array(
													'standard' => '#ffffff',
													'hover' => '#ffffff',
													'bg' => '#c27b7f',
													'hover_bg' => '#876585',
													'border' => '#c27b7f',
													'hover_border' => '#876585',
												),
												'dependency' => array( 'show_book_category', '==', 'true' ),
											),
											array(
												'id'      => 'bop_book_category_alignment',
												'type'    => 'button_set',
												'title'   => esc_html__( 'Alignment', 'bookify-pro' ),
												'options' => array(
													'left' => wp_kses( __( '<i class="fas fa-align-left" title="Left"></i>', 'bookify-pro' ), array( 'i' => array( 'class' => array() ) ) ),
													'center' => wp_kses( __( '<i class="fas fa-align-center" title="Center"></i>', 'bookify-pro' ), array( 'i' => array( 'class' => array() ) ) ),
													'right' => wp_kses( __( '<i class="fas fa-align-right" title="Right"></i>', 'bookify-pro' ), array( 'i' => array( 'class' => array() ) ) ),
												),
												'default' => 'left',
												'dependency' => array( 'show_book_category', '==', 'true' ),
											),
											array(
												'id'       => 'bop_book_category_padding',
												'type'     => 'spacing',
												'title'    => esc_html__( 'Padding', 'bookify-pro' ),
												'sanitize' => 'bop_sanitize_number_array_field',
												'units'    => array( 'px' ),
												'min'      => -100,
												'default'  => array(
													'top'  => '3',
													'right' => '10',
													'bottom' => '3',
													'left' => '10',
												),
												'dependency' => array( 'show_book_category', '==', 'true' ),
											),
											array(
												'id'       => 'bop_category_margin',
												'type'     => 'spacing',
												'title'    => esc_html__( 'Margin', 'bookify-pro' ),
												'sanitize' => 'bop_sanitize_number_array_field',
												'units'    => array( 'px' ),
												'min'      => -100,
												'default'  => array(
													'top'  => '0',
													'right' => '0',
													'bottom' => '15',
													'left' => '0',
												),
												'dependency' => array( 'show_book_category', '==', 'true' ),
											),
											array(
												'id'       => 'bop_category_button_radius',
												'type'     => 'spacing',
												'title'    => esc_html__( 'Border Radius', 'bookify-pro' ),
												'sanitize' => 'bop_sanitize_number_array_field',
												'all'      => true,
												'default'  => array(
													'all'  => '0',
													'unit' => 'px',
												),
												'units'    => array( 'px', '%' ),
												'dependency' => array( 'show_book_category', '==', 'true' ),
											),
										),
									),
								),
							),
							array(
								'id'         => 'bop_book_fildes',
								'class'      => 'bop_book_fildes ta-product-not-fields',
								'type'       => 'accordion',
								'accordions' => array(
									array(
										'title'  => esc_html__( 'Book Fields', 'bookify-pro' ),
										'fields' => array(
											array(
												'id'       => 'show_book_fildes',
												'type'     => 'switcher',
												'title'    => esc_html__( 'Book Fields', 'bookify-pro' ),
												'text_on'  => esc_html__( 'Show', 'bookify-pro' ),
												'text_off' => esc_html__( 'Hide', 'bookify-pro' ),
												'default'  => true,
												'text_width' => 80,
											),
											array(
												'id'      => 'show_book_column',
												'type'    => 'button_set',
												'options' => array(
													'1' => esc_html__( '1 Column', 'bookify-pro' ),
													'2' => esc_html__( '2 Column', 'bookify-pro' ),
													'3' => esc_html__( '3 Column', 'bookify-pro' ),
												),
												'default' => '2',
												'dependency' => array( 'bop_layout_preset|show_book_fildes', '!=|==', 'list_layout|true', 'all' ),
											),
											array(
												'id'      => 'bop_book_fildes_group',
												'class'   => 'bop_custom_group_design',
												'type'    => 'group',
												'button_title' => esc_html__( 'Add New Meta', 'bookify-pro' ),
												'dependency' => array( 'show_book_fildes', '==', 'true' ),
												'fields'  => array(
													array(
														'id'       => 'select_book_fildes',
														'class'       => 'select_book_fildes',
														'type'     => 'select',
														'title'    => esc_html__( 'Select Meta', 'bookify-pro' ),
														'placeholder' => esc_html__( 'Select a meta', 'bookify-pro' ),
														'options'  => array(
															'book_author'     => esc_html__( 'Book Author', 'bookify-pro' ),
															'publisher'     => esc_html__( 'Publisher', 'bookify-pro' ),
															'publish_date'     => esc_html__( 'Publish Date', 'bookify-pro' ),
															'price'     => esc_html__( 'Price', 'bookify-pro' ),
															'isbn'     => esc_html__( 'ISBN', 'bookify-pro' ),
															'isbn_10'     => esc_html__( 'ISBN-10', 'bookify-pro' ),
															'isbn_13'     => esc_html__( 'ISBN-13', 'bookify-pro' ),
															'asin'     => esc_html__( 'ASIN', 'bookify-pro' ),
															'subject'     => esc_html__( 'Subject', 'bookify-pro' ),
															'genre'     => esc_html__( 'Genre', 'bookify-pro' ),
														),
													),
													array(
														'id'      => 'select_book_fildes_icon',
														'class'      => 'select_book_fildes_icon',
														'type'    => 'icon',
														'title'   => esc_html__( 'Meta Icon', 'bookify-pro' ),
														'default' => 'far fa-folder',
													),
													array(
														'id'    => 'select_book_fildes_date_format',
														'type'  => 'text',
														'title' => ' ',
														'class' => 'select_book_fildes_date_format',
														'placeholder' => esc_html__( 'F j, Y', 'bookify-pro' ),
														'default'   => esc_html__( 'F j, Y', 'bookify-pro' ),
														'desc' => __( 'To define format, check <a href="https://wordpress.org/support/article/formatting-date-and-time/" target="_blank" rel="noopener noreferrer nofollow"><em>this doc</em></a>.', 'bookify-pro' ),
														'dependency' => array( 'select_book_fildes', '==', 'publish_date' ),
													),
													array(
														'id'       => 'show_before_text',
														'type'     => 'switcher',
														'title'    => esc_html__( 'Before Text', 'bookify-pro' ),
														'text_on'  => esc_html__( 'Show', 'bookify-pro' ),
														'text_off' => esc_html__( 'Hide', 'bookify-pro' ),
														'text_width' => 80,
													),
													array(
														'id'       => 'bop_before_text',
														'type'     => 'text',
														'title'    => ' ',
														'dependency' => array( 'show_before_text', '==', 'true' ),
													),
												),

												'default' => array(
													array(
														'select_book_fildes'     => 'book_author',
														'select_book_fildes_icon'    => 'fas fa-user-edit',
													),
													array(
														'select_book_fildes'     => 'publisher',
														'select_book_fildes_icon'    => 'fas fa-user',
													),
													array(
														'select_book_fildes'     => 'publish_date',
														'select_book_fildes_icon'    => 'fas fa-calendar-alt',
													),
												),
											),
											array(
												'id'      => 'book_fildes_alignment',
												'type'    => 'button_set',
												'title'   => esc_html__( 'Alignment', 'bookify-pro' ),
												'options' => array(
													'left' => wp_kses( __( '<i class="fas fa-align-left" title="Left"></i>', 'bookify-pro' ), array( 'i' => array( 'class' => array() ) ) ),
													'center' => wp_kses( __( '<i class="fas fa-align-center" title="Center"></i>', 'bookify-pro' ), array( 'i' => array( 'class' => array() ) ) ),
													'right' => wp_kses( __( '<i class="fas fa-align-right" title="Right"></i>', 'bookify-pro' ), array( 'i' => array( 'class' => array() ) ) ),
												),
												'default' => 'left',
												'dependency' => array( 'bop_layout_preset|show_book_fildes', '!=|==', 'list_layout|true', 'all' ),
											),
											array(
												'id'       => 'book_fildes_between_padding',
												'type'     => 'spacing',
												'title'    => esc_html__( 'Padding Between Book Meta', 'bookify-pro' ),
												'sanitize' => 'bop_sanitize_number_array_field',
												'units'    => array( 'px' ),
												'min'      => -5,
												'dependency' => array( 'show_book_fildes', '==', 'true' ),
												'default'  => array(
													'top'  => '0',
													'right' => '0',
													'bottom' => '0',
													'left' => '0',
												),
											),
											array(
												'id'       => 'book_fildes_margin',
												'type'     => 'spacing',
												'title'    => esc_html__( 'Margin', 'bookify-pro' ),
												'sanitize' => 'bop_sanitize_number_array_field',
												'units'    => array( 'px' ),
												'min'      => -100,
												'dependency' => array( 'show_book_fildes', '==', 'true' ),
												'default'  => array(
													'top'  => '0',
													'right' => '0',
													'bottom' => '15',
													'left' => '0',
												),
											),
										),
									),
								),
							),
							array(
								'id'         => 'bop_book_price',
								'class'      => 'bop_book_price',
								'type'       => 'accordion',
								'accordions' => array(
									array(
										'title'  => esc_html__( 'Book Price', 'bookify-pro' ),
										'fields' => array(
											array(
												'id'      => 'show_book_price',
												'type'    => 'button_set',
												'title'   => esc_html__( 'Price', 'bookify-pro' ),
												'options' => array(
													'none' => esc_html__( 'None', 'bookify-pro' ),
													'price' => esc_html__( 'Price', 'bookify-pro' ),
													'regular_sale' => esc_html__( 'Regular and Sale Price', 'bookify-pro' ),
												),
												'default' => 'none',
											),
											array(
												'id'      => 'show_book_price_text',
												'type'    => 'text',
												'title'   => esc_html__( 'Price Before Text', 'bookify-pro' ),
												'default' => esc_html__( 'Price:', 'bookify-pro' ),
												'dependency' => array( 'show_book_price', '!=', 'none' ),
											),
											array(
												'id'      => 'show_book_price_alignment',
												'type'    => 'button_set',
												'title'   => esc_html__( 'Alignment', 'bookify-pro' ),
												'options' => array(
													'left' => wp_kses( __( '<i class="fas fa-align-left" title="Left"></i>', 'bookify-pro' ), array( 'i' => array( 'class' => array() ) ) ),
													'center' => wp_kses( __( '<i class="fas fa-align-center" title="Center"></i>', 'bookify-pro' ), array( 'i' => array( 'class' => array() ) ) ),
													'right' => wp_kses( __( '<i class="fas fa-align-right" title="Right"></i>', 'bookify-pro' ), array( 'i' => array( 'class' => array() ) ) ),
												),
												'default' => 'left',
												'dependency' => array( 'show_book_price', '!=', 'none' ),
											),
											array(
												'id'       => 'book_fildes_margin',
												'type'     => 'spacing',
												'title'    => esc_html__( 'Margin', 'bookify-pro' ),
												'sanitize' => 'bop_sanitize_number_array_field',
												'units'    => array( 'px' ),
												'min'      => -100,
												'dependency' => array( 'show_book_price', '!=', 'none' ),
												'default'  => array(
													'top'  => '0',
													'right' => '0',
													'bottom' => '15',
													'left' => '0',
												),
											),
										),
									),
								),
							),
							array(
								'id'         => 'bop_post_content',
								'type'       => 'accordion',
								'accordions' => array(
									array(
										'title'  => esc_html__( 'Content', 'bookify-pro' ),
										'fields' => array(
											array(
												'id'       => 'show_post_content',
												'type'     => 'switcher',
												'title'    => esc_html__( 'Content', 'bookify-pro' ),
												'text_on'  => esc_html__( 'Show', 'bookify-pro' ),
												'text_off' => esc_html__( 'Hide', 'bookify-pro' ),
												'default'  => true,
												'text_width' => 80,
											),
											array(
												'id'      => 'post_content_type',
												'type'    => 'select',
												'title'   => esc_html__( 'Content Display Type', 'bookify-pro' ),
												'options' => array(
													'excerpt'      => esc_html__( 'Excerpt', 'bookify-pro' ),
													'limit_content' => esc_html__( 'Content with Limit', 'bookify-pro' ),
													'full_content' => esc_html__( 'Full Content', 'bookify-pro' ),
												),
												'default' => 'limit_content',
												'dependency' => array( 'show_post_content', '==', 'true' ),
											),
											array(
												'id'      => 'bop_content_length_type',
												'type'    => 'button_set',
												'title'   => esc_html__( 'Content Length Type', 'bookify-pro' ),
												'options' => array(
													'words'    => esc_html__( 'Words', 'bookify-pro' ),
													'characters' => esc_html__( 'Characters', 'bookify-pro' ),
												),
												'default' => 'words',
												'dependency' => array( 'show_post_content|post_content_type', '==|==', 'true|limit_content' ),
											),
											array(
												'id'       => 'bop_content_limit',
												'type'     => 'spinner',
												'title'    => esc_html__( 'Words Length', 'bookify-pro' ),
												'sanitize' => 'bop_sanitize_number_field',
												'default'  => 30,
												'max'      => 10000,
												'dependency' => array( 'show_post_content|post_content_type|bop_content_length_type', '==|==|==', 'true|limit_content|words' ),
											),
											array(
												'id'       => 'bop_content_characters_limit',
												'type'     => 'spinner',
												'title'    => esc_html__( 'Characters Length', 'bookify-pro' ),
												'sanitize' => 'bop_sanitize_number_field',
												'default'  => 300,
												'max'      => 10000,
												'dependency' => array( 'show_post_content|post_content_type|bop_content_length_type', '==|==|==', 'true|limit_content|characters' ),
											),
											array(
												'id'       		=> 'post_content_margin',
												'type'     		=> 'spacing',
												'title'    		=> esc_html__( 'Margin', 'bookify-pro' ),
												'sanitize' 		=> 'bop_sanitize_number_array_field',
												'units'    		=> array( 'px' ),
												'min'      		=> -100,
												'default'  		=> array(
													'top'  		=> '0',
													'right' 	=> '0',
													'bottom' 	=> '15',
													'left' 		=> '0',
												),
												'dependency' => array( 'show_post_content', '==', 'true' ),
											),
											array(
												'id'      => 'bop_strip_tags',
												'type'    => 'radio',
												'title'   => esc_html__( 'HTML Tags', 'bookify-pro' ),
												'options' => array(
													'allow_all'  => esc_html__( 'Allow All', 'bookify-pro' ),
													'strip_all'  => esc_html__( 'Strip All', 'bookify-pro' ),
													'allow_some' => esc_html__( 'Allow Some', 'bookify-pro' ),
												),
												'default' 		=> 'allow_all',
												'dependency' 	=> array( 'show_post_content|post_content_type', '==|!=', 'true|excerpt' ),
											),
											array(
												'id'    => 'bop_allow_tag_name',
												'type'  => 'text',
												'title' => esc_html__( 'Allow HTML Tags Names', 'bookify-pro' ),
												'title_help' => esc_html__( 'Separate multiple tags by comma, e.g. h1,h2', 'bookify-pro' ),
												'dependency' => array( 'show_post_content|bop_strip_tags', '==|==', 'true|allow_some' ),
											),
											array(
												'id'      => 'post_content_ellipsis',
												'type'    => 'text',
												'title'   => esc_html__( 'Ellipsis Points Ending Excerpt', 'bookify-pro' ),
												'default' => '...',
												'dependency' => array( 'show_post_content|post_content_type', '==|!=', 'true|full_content' ),
											),
										),
									),
								),
							),
							array(
								'id'         => 'bop_post_content_readmore',
								'type'       => 'accordion',
								'accordions' => array(
									array(
										'title'  => esc_html__( 'Read more', 'bookify-pro' ),
										'fields' => array(
											// ReadMore settings.
											array(
												'id'       => 'show_read_more',
												'type'     => 'switcher',
												'title'    => esc_html__( 'Read More', 'bookify-pro' ),
												'text_on'  => esc_html__( 'Show', 'bookify-pro' ),
												'text_off' => esc_html__( 'Hide', 'bookify-pro' ),
												'default'  => true,
												'text_width' => 80,
											),
											array(
												'id'      => 'read_more_type',
												'type'    => 'button_set',
												'title'   => esc_html__( 'Read More Type', 'bookify-pro' ),
												'options' => array(
													'button'    => esc_html__( 'Button', 'bookify-pro' ),
													'text_link' => esc_html__( 'Text Link', 'bookify-pro' ),
												),
												'default' => 'button',
												'dependency' => array( 'show_read_more', '==', 'true' ),
											),
											array(
												'id'      => 'bop_read_label',
												'type'    => 'text',
												'title'   => esc_html__( 'Read More Label', 'bookify-pro' ),
												'default' => esc_html__( 'Read More', 'bookify-pro' ),
												'dependency' => array( 'show_read_more', '==', 'true' ),
											),
											array(
												'id'      => 'readmore_color_button',
												'type'    => 'color_group',
												'title'   => esc_html__( 'Read More Color', 'bookify-pro' ),
												'options' => array(
													'standard' => esc_html__( 'Text Color', 'bookify-pro' ),
													'hover' => esc_html__( 'Text Hover Color', 'bookify-pro' ),
													'bg' => esc_html__( 'Background', 'bookify-pro' ),
													'hover_bg' => esc_html__( 'Hover Background', 'bookify-pro' ),
													'border' => esc_html__( 'Border', 'bookify-pro' ),
													'hover_border' => esc_html__( 'Hover Border', 'bookify-pro' ),
												),
												'default' => array(
													'standard' => '#ffffff',
													'hover' => '#ffffff',
													'bg' => '#c27b7f',
													'hover_bg' => '#876585',
													'border' => '#c27b7f',
													'hover_border' => '#876585',
												),
												'dependency' => array( 'show_read_more|read_more_type', '==|==', 'true|button' ),
											),
											array(
												'id'       		=> 'readmore_padding',
												'type'     		=> 'spacing',
												'title'    		=> esc_html__( 'Padding', 'bookify-pro' ),
												'sanitize' 		=> 'bop_sanitize_number_array_field',
												'units'    		=> array( 'px' ),
												'min'      		=> -100,
												'default'  		=> array(
													'top'  		=> '6',
													'right' 	=> '20',
													'bottom' 	=> '6',
													'left' 		=> '20',
												),
												'dependency' => array( 'show_read_more|read_more_type', '==|==', 'true|button' ),
											),
											array(
												'id'       => 'readmore_margin',
												'type'     => 'spacing',
												'title'    => esc_html__( 'Margin', 'bookify-pro' ),
												'sanitize' => 'bop_sanitize_number_array_field',
												'units'    => array( 'px' ),
												'min'      => -100,
												'default'  => array(
													'top'  => '0',
													'right' => '0',
													'bottom' => '15',
													'left' => '0',
												),
												'dependency' => array( 'show_read_more', '==', 'true' ),
											),
											array(
												'id'       => 'readmore_button_radius',
												'type'     => 'spacing',
												'title'    => esc_html__( 'Border Radius', 'bookify-pro' ),
												'sanitize' => 'bop_sanitize_number_array_field',
												'all'      => true,
												'default'  => array(
													'all'  => '0',
													'unit' => 'px',
												),
												'units'    => array( 'px', '%' ),
												'dependency' => array( 'show_read_more|read_more_type', '==|==', 'true|button' ),
											),
											array(
												'id'      => 'readmore_color_text',
												'type'    => 'color_group',
												'title'   => esc_html__( 'Read More Color', 'bookify-pro' ),
												'options' => array(
													'standard' => esc_html__( 'Text Color', 'bookify-pro' ),
													'hover' => esc_html__( 'Text Hover Color', 'bookify-pro' ),
												),
												'default' => array(
													'standard' => '#ffffff',
													'hover' => '#c27b7f',
												),
												'dependency' => array( 'show_read_more|read_more_type', '==|==', 'true|text_link' ),
											),

										),
									),
								),
							),
							array(
								'id'         => 'bop_post_buy_now_button',
								'type'       => 'accordion',
								'accordions' => array(
									array(
										'title'  => esc_html__( 'Buy Now', 'bookify-pro' ),
										'fields' => array(
											// Buy Now settings.
											array(
												'id'       => 'show_bye_now_button',
												'type'     => 'switcher',
												'title'    => esc_html__( 'Buy Now', 'bookify-pro' ),
												'text_on'  => esc_html__( 'Show', 'bookify-pro' ),
												'text_off' => esc_html__( 'Hide', 'bookify-pro' ),
												'default'  => true,
												'text_width' => 80,
											),
											array(
												'id'      => 'buy_now_color_button',
												'type'    => 'color_group',
												'title'   => esc_html__( 'Buy Now Color', 'bookify-pro' ),
												'options' => array(
													'standard' => esc_html__( 'Text Color', 'bookify-pro' ),
													'hover' => esc_html__( 'Text Hover Color', 'bookify-pro' ),
													'bg' => esc_html__( 'Background', 'bookify-pro' ),
													'hover_bg' => esc_html__( 'Hover Background', 'bookify-pro' ),
													'border' => esc_html__( 'Border', 'bookify-pro' ),
													'hover_border' => esc_html__( 'Hover Border', 'bookify-pro' ),
												),
												'default' => array(
													'standard' => '#ffffff',
													'hover' => '#ffffff',
													'bg' => '#c27b7f',
													'hover_bg' => '#876585',
													'border' => '#c27b7f',
													'hover_border' => '#876585',
												),
												'dependency' => array( 'show_bye_now_button', '==', 'true' ),
											),
											array(
												'id'       => 'buy_now_padding',
												'type'     => 'spacing',
												'title'    => esc_html__( 'Padding', 'bookify-pro' ),
												'sanitize' => 'bop_sanitize_number_array_field',
												'units'    => array( 'px' ),
												'min'      => -100,
												'default'  => array(
													'top'  => '6',
													'right' => '20',
													'bottom' => '6',
													'left' => '20',
												),
												'dependency' => array( 'show_bye_now_button', '==', 'true' ),
											),
											array(
												'id'       => 'buy_now_margin',
												'type'     => 'spacing',
												'title'    => esc_html__( 'Margin', 'bookify-pro' ),
												'sanitize' => 'bop_sanitize_number_array_field',
												'units'    => array( 'px' ),
												'min'      => -100,
												'default'  => array(
													'top'  => '0',
													'right' => '0',
													'bottom' => '15',
													'left' => '0',
												),
												'dependency' => array( 'show_bye_now_button', '==', 'true' ),
											),
											array(
												'id'       => 'buy_now_button_radius',
												'type'     => 'spacing',
												'title'    => esc_html__( 'Border Radius', 'bookify-pro' ),
												'sanitize' => 'bop_sanitize_number_array_field',
												'all'      => true,
												'default'  => array(
													'all'  => '0',
													'unit' => 'px',
												),
												'units'    => array( 'px', '%' ),
												'dependency' => array( 'show_bye_now_button', '==', 'true' ),
											),
											array(
												'id'      => 'buy_now_color_text',
												'type'    => 'color_group',
												'title'   => esc_html__( 'Buy Now Color', 'bookify-pro' ),
												'options' => array(
													'standard' => esc_html__( 'Text Color', 'bookify-pro' ),
													'hover' => esc_html__( 'Text Hover Color', 'bookify-pro' ),
												),
												'default' => array(
													'standard' => '#ffffff',
													'hover' => '#c27b7f',
												),
												'dependency' => array( 'show_bye_now_button', '==', 'true' ),
											),

										),
									),
								),
							),
							array(
								'id'         => 'bop_social_share',
								'type'       => 'accordion',
								'class'      => 'bop-pro-only',
								'accordions' => array(
									array(
										'title'  => esc_html__( 'Social Share', 'bookify-pro' ),
										'fields' => array(
											array(
												'id'       => 'social_sharing_media',
												'type'     => 'select',
												'title'    => esc_html__( 'Sharing Media', 'bookify-pro' ),
												'chosen'   => true,
												'sortable' => true,
												'multiple' => true,
												'placeholder' => esc_html__( 'Choose an option', 'bookify-pro' ),
												'options'  => array(
													'facebook' 	=> esc_html__( 'Facebook', 'bookify-pro' ),
													'twitter' 	=> esc_html__( 'Twitter', 'bookify-pro' ),
													'linkedIn' 	=> esc_html__( 'LinkedIn', 'bookify-pro' ),
													'pinterest' => esc_html__( 'Pinterest', 'bookify-pro' ),
													'email' 	=> esc_html__( 'Email', 'bookify-pro' ),
													'instagram' => esc_html__( 'Instagram', 'bookify-pro' ),
													'vk'   		=> esc_html__( 'VK', 'bookify-pro' ),
													'digg' 		=> esc_html__( 'digg', 'bookify-pro' ),
													'tumblr' 	=> esc_html__( 'Tumblr', 'bookify-pro' ),
													'reddit' 	=> esc_html__( 'Reddit', 'bookify-pro' ),
													'whatsapp' 	=> esc_html__( 'WhatsApp', 'bookify-pro' ),
													'pocket' 	=> esc_html__( 'Pocket', 'bookify-pro' ),
													'xing' 		=> esc_html__( 'Xing', 'bookify-pro' ),
												),
											),
											array(
												'id'      => 'social_position',
												'type'    => 'button_set',
												'title'   => esc_html__( 'Alignment', 'bookify-pro' ),
												'options' => array(
													'left' 		=> wp_kses( __( '<i class="fas fa-align-left" title="Left"></i>', 'bookify-pro' ), array( 'i' => array( 'class' 	=> array() ) ) ),
													'center' 	=> wp_kses( __( '<i class="fas fa-align-center" title="Center"></i>', 'bookify-pro' ), array( 'i' => array( 'class' 	=> array() ) ) ),
													'right' 	=> wp_kses( __( '<i class="fas fa-align-right" title="Right"></i>', 'bookify-pro' ), array( 'i' => array( 'class' 	=> array() ) ) ),
												),
												'default' => 'left',
												'dependency' => array( 'social_sharing_media', '!=', '' ),
											),
											array(
												'id'       => 'social_margin',
												'type'     => 'spacing',
												'title'    => esc_html__( 'Margin', 'bookify-pro' ),
												'sanitize' => 'bop_sanitize_number_array_field',
												'min'      => -100,
												'units'    => array( 'px' ),
												'default'  => array(
													'top'  => '0',
													'right' => '0',
													'bottom' => '0',
													'left' => '0',
												),
												'dependency' => array( 'social_sharing_media', '!=', '' ),
											),
											array(
												'id'      => 'social_icon_shape',
												'class'   => 'social_icon_shape',
												'type'    => 'layout_preset',
												'title'   => esc_html__( 'Icon Shape', 'bookify-pro' ),
												'options' => array(
													'bop_circle'    => array(
														'image'     => BOP_URL . 'admin/assets/img/circle-icon.png',
														'text'      => esc_html__( 'Circle', 'bookify-pro' ),
													),
													'bop_rounded'   => array(
														'image'     => BOP_URL . 'admin/assets/img/round-icon.png',
														'text'      => esc_html__( 'Rounded', 'bookify-pro' ),
													),
													'bop_square'    => array(
														'image'       => BOP_URL . 'admin/assets/img/square-icon.png',
														'text'      => esc_html__( 'Square', 'bookify-pro' ),
													),
													'icon_only'     => array(
														'image'     => BOP_URL . 'admin/assets/img/only-icon.png',
														'text'      => esc_html__( 'Icon only', 'bookify-pro' ),
													),
												),
												'default' => 'bop_circle',
												'dependency' => array( 'social_sharing_media', '!=', '' ),
											),
											array(
												'id'      => 'social_icon_custom_color',
												'type'    => 'checkbox',
												'title'   => esc_html__( 'Custom Color', 'bookify-pro' ),
												'default' => false,
												'dependency' => array( 'social_sharing_media', '!=', '' ),
											),
											array(
												'id'      => 'social_icon_color',
												'type'    => 'color_group',
												'title'   => esc_html__( 'Icon Color', 'bookify-pro' ),
												'options' => array(
													'icon_color'       => esc_html__( 'Icon', 'bookify-pro' ),
													'icon_hover_color' => esc_html__( 'Icon Hover', 'bookify-pro' ),
													'icon_bg'       => esc_html__( 'Background', 'bookify-pro' ),
													'icon_bg_hover' => esc_html__( 'Background Hover', 'bookify-pro' ),
													'icon_border_hover' => esc_html__( 'Border Hover', 'bookify-pro' ),
												),
												'default' => array(
													'icon_color'        => '#ffffff',
													'icon_hover_color'  => '#ffffff',
													'icon_bg'           => '#c27b7f',
													'icon_bg_hover'     => '#876585',
													'icon_border_hover' => '#876585',
												),
												'dependency' => array( 'social_icon_custom_color|social_sharing_media', '==|!=', 'true|' ),
											),
											array(
												'id'      => 'social_icon_border',
												'type'    => 'border',
												'title'   => esc_html__( 'Icon Border', 'bookify-pro' ),
												'default' => array(
													'all' => '1',
													'style' => 'solid',
													'color' => '#c27b7f',
												),
												'all'     => true,
												'dependency' => array( 'social_icon_custom_color|social_sharing_media', '==|!=', 'true|' ),
											),
										),
									),
								),
							), // PCP Post Social.
							array(
								'id'         => 'bop_custom_fields',
								'type'       => 'accordion',
								'accordions' => array(
									array(
										'title'  => esc_html__( 'Custom Fields', 'bookify-pro' ),
										'fields' => array(
											// The Group Fields.
											array(
												'id'     => 'bop_custom_fields_group',
												'class'  => 'bop_custom_group_design',
												'type'   => 'group',
												'accordion_title_auto' => true,
												'accordion_title_number' => true,
												'button_title' => esc_html__( 'Add New Custom Field', 'bookify-pro' ),
												'fields' => array(
													array(
														'id'   => 'bop_select_custom_field_key',
														'type' => 'select',
														'title' => esc_html__( 'Custom Fields', 'bookify-pro' ),
														'options' => 'custom_fields',
														'chosen' => true,
														'attributes' => array(
															'style' => 'width: 200px;',
														),
														'empty_message' => esc_html__( 'No custom field found.', 'bookify-pro' ),
													),
													array(
														'id'   => 'bop_custom_meta_icon',
														'type' => 'icon',
														'title' => esc_html__( 'Icon Before Name', 'bookify-pro' ),
														'default' => 'fas fa-calendar-alt',
													),
													array(
														'id'   		=> 'show_custom_field_name',
														'type' 		=> 'switcher',
														'title'    	=> esc_html__( 'Custom Field Name', 'bookify-pro' ),
														'text_on' 	=> esc_html__( 'Show', 'bookify-pro' ),
														'text_off' 	=> esc_html__( 'Hide', 'bookify-pro' ),
														'default' 	=> false,
														'text_width' => 80,
													),
													array(
														'id'   			=> 'customize_custom_field_name',
														'type' 			=> 'text',
														'title' 		=> esc_html__( 'Customize Field Name', 'bookify-pro' ),
														'dependency' 	=> array( 'show_custom_field_name', '==', 'true' ),
													),
													array(
														'id'   => 'colon_after_custom_field_name',
														'type' => 'switcher',
														'title' => esc_html__( 'Show Colon \':\'', 'bookify-pro' ),
														'title_help' => esc_html__( 'Show colon after field name.', 'bookify-pro' ),
														'text_on' => esc_html__( 'Show', 'bookify-pro' ),
														'text_off' => esc_html__( 'Hide', 'bookify-pro' ),
														'text_width' => 80,
														'default' => false,
														'dependency' => array( 'show_custom_field_name', '==', 'true' ),
													),
												),
											), // Group field end.
											array(
												'id'      => 'which_plugin_used',
												'type'    => 'button_set',
												'title'   => esc_html__( 'Select Plugin', 'bookify-pro' ),
												'title_help' => esc_html__( 'Select plugin which is used to make the above custom fields.', 'bookify-pro' ),
												'options' => array(
													'auto' => esc_html__( 'Auto Detect', 'bookify-pro' ),
													'_acf' => esc_html__( 'Advanced Custom Fields', 'bookify-pro' ),
													'_pods' => esc_html__( 'Pods', 'bookify-pro' ),
													'_toolset' => esc_html__( 'Toolset', 'bookify-pro' ),
												),
												'default' => 'auto',
											),
											array(
												'id'    => 'bop_embed_cf_content',
												'type'  => 'checkbox',
												'title' => esc_html__( 'Embed Audio, Video or Image etc.', 'bookify-pro' ),
												'desc'  => __( 'Embed the content if it is audio, video, or tweets etc. <a target="_blank" href="https://wordpress.org/support/article/embeds/#okay-so-what-sites-can-i-embed-from">See embed supported content list.</a>', 'bookify-pro' ),
											),
											array(
												'id'       => 'bop_custom_fields_margin',
												'type'     => 'spacing',
												'title'    => esc_html__( 'Margin', 'bookify-pro' ),
												'sanitize' => 'bop_sanitize_number_array_field',
												'min'      => -100,
												'units'    => array( 'px' ),
												'default'  => array(
													'top'  => '0',
													'right' => '0',
													'bottom' => '15',
													'left' => '0',
												),
											),
										), // End Fields array.
									),
								), // Accordion.
							), // Custom fields end.
						),
					),
					array(
						'id'         => 'show_post_pagination',
						'type'       => 'switcher',
						'text_on'    => esc_html__( 'Enabled', 'bookify-pro' ),
						'text_off'   => esc_html__( 'Disabled', 'bookify-pro' ),
						'text_width' => 100,
						'title'      => esc_html__( 'Pagination', 'bookify-pro' ),
						'subtitle'   => esc_html__( 'Enabled/Disabled item pagination.', 'bookify-pro' ),
						'default'    => true,
						'dependency' => array( 'bop_layout_preset', '!=', 'carousel_layout', true ),
					),
					array(
						'id'         => 'post_pagination_type',
						'type'       => 'radio',
						'title'      => esc_html__( 'Pagination Type', 'bookify-pro' ),
						'subtitle'   => esc_html__( 'Choose a pagination type.', 'bookify-pro' ),
						'options'    => array(
							'ajax_load_more'  => esc_html__( 'Load More Button (Ajax)', 'bookify-pro' ),
							'ajax_pagination' => esc_html__( 'Ajax Number Pagination', 'bookify-pro' ),
							'infinite_scroll' => esc_html__( 'Infinite Scroll (Ajax)', 'bookify-pro' ),
							'no_ajax'         => esc_html__( 'No Ajax (Normal Pagination)', 'bookify-pro' ),
						),
						'default'    => 'ajax_load_more',
						'dependency' => array( 'bop_layout_preset|show_post_pagination', 'not-any|==', 'carousel_layout,filter_layout|true', true ),
					),
					array(
						'id'         => 'filter_pagination_type',
						'type'       => 'radio',
						'title'      => esc_html__( 'Filter Pagination Type', 'bookify-pro' ),
						'subtitle'   => esc_html__( 'Choose a pagination type.', 'bookify-pro' ),
						'options'    => array(
							'ajax_load_more'  => esc_html__( 'Load More Button (Ajax)', 'bookify-pro' ),
							'infinite_scroll' => esc_html__( 'Infinite Scroll (Ajax)', 'bookify-pro' ),
						),
						'default'    => 'ajax_load_more',
						'dependency' => array( 'bop_layout_preset|show_post_pagination', '==|==', 'filter_layout|true', true ),
					),
					array(
						'id'         => 'post_pagination_type_mobile',
						'type'       => 'select',
						'title'      => esc_html__( 'Pagination Type for Mobile', 'bookify-pro' ),
						'subtitle'   => esc_html__( 'Choose a pagination type for mobile view.', 'bookify-pro' ),
						'options'    => array(
							'ajax_load_more'  => esc_html__( 'Load More Button (Ajax)', 'bookify-pro' ),
							'ajax_pagination' => esc_html__( 'Ajax Pagination', 'bookify-pro' ),
							'infinite_scroll' => esc_html__( 'Infinite Scroll (Ajax)', 'bookify-pro' ),
							'no_ajax'         => esc_html__( 'No Ajax (Normal Pagination)', 'bookify-pro' ),
						),
						'default'    => 'infinite_scroll',
						'dependency' => array( 'bop_layout_preset|show_post_pagination', 'not-any|==', 'carousel_layout,filter_layout|true', true ),
					),
					array(
						'id'         => 'load_more_button_text',
						'type'       => 'text',
						'title'      => esc_html__( 'Load More Button Label', 'bookify-pro' ),
						'subtitle'   => esc_html__( 'Set the label for load more button.', 'bookify-pro' ),
						'default'    => esc_html__( 'Load More', 'bookify-pro' ),
						'dependency' => array( 'bop_layout_preset|show_post_pagination', '!=|==', 'carousel_layout|true', true ),
					),
					array(
						'id'         => 'load_more_ending_message',
						'type'       => 'text',
						'title'      => esc_html__( 'Ending Message', 'bookify-pro' ),
						'subtitle'   => esc_html__( 'Set ending message for load more/infinite scroll.', 'bookify-pro' ),
						'default'    => esc_html__( 'No more books available', 'bookify-pro' ),
						'dependency' => array( 'bop_layout_preset|show_post_pagination', '!=|==', 'carousel_layout|true', true ),
					),
					array(
						'id'         => 'bop_pagination_btn_color',
						'type'       => 'color_group',
						'title'      => esc_html__( 'Pagination  Color', 'bookify-pro' ),
						'subtitle'   => esc_html__( 'Set Pagination color', 'bookify-pro' ),
						'options'    => array(
							'text_color'        => esc_html__( 'Text Color', 'bookify-pro' ),
							'text_acolor'       => esc_html__( 'Text Active Color', 'bookify-pro' ),
							'border_color'      => esc_html__( 'Border Color', 'bookify-pro' ),
							'border_acolor'     => esc_html__( 'Border Active Color', 'bookify-pro' ),
							'background'        => esc_html__( 'Background', 'bookify-pro' ),
							'active_background' => esc_html__( 'Active BG', 'bookify-pro' ),
						),
						'default'    => array(
							'text_color'        => '#5e5e5e',
							'text_acolor'       => '#ffffff',
							'border_color'      => '#bbbbbb',
							'border_acolor'     => '#c27b7f',
							'background'        => '#ffffff',
							'active_background' => '#c27b7f',
						),
						'dependency' => array( 'bop_layout_preset|show_post_pagination|post_pagination_type', '!=|==|any', 'carousel_layout|true|ajax_pagination,no_ajax', true ),
					),
					array(
						'id'         => 'bop_pagination_btn_border_radius',
						'type'       => 'spacing',
						'title'      => esc_html__( 'Pagination Border Radius', 'bookify-pro' ),
						'subtitle'   => esc_html__( 'Set pagination border radius for item.', 'bookify-pro' ),
						'all'        => true,
						'units'      => array( 'px', '%' ),
						'default'    => array(
							'all' => '0',
						),
						'dependency' => array( 'bop_layout_preset|show_post_pagination|post_pagination_type', '!=|==|any', 'carousel_layout|true|ajax_pagination,no_ajax', true ),
					),
					array(
						'id'         => 'bop_pagination_btn_margin_between',
						'type'       => 'spacing',
						'title'      => esc_html__( 'Pagination Margin Between', 'bookify-pro' ),
						'subtitle'   => esc_html__( 'Set pagination border radius for item.', 'bookify-pro' ),
						'all'        => true,
						'units'      => array( 'px' ),
						'default'    => array(
							'all' => '0',
						),
						'dependency' => array( 'bop_layout_preset|show_post_pagination|post_pagination_type', '!=|==|any', 'carousel_layout|true|ajax_pagination,no_ajax', true ),
					),
					array(
						'id'         => 'bop_loadmore_btn_color',
						'type'       => 'color_group',
						'title'      => esc_html__( 'Load More Button Color', 'bookify-pro' ),
						'subtitle'   => esc_html__( 'Set load more button color.', 'bookify-pro' ),
						'options'    => array(
							'text_color'        => esc_html__( 'Text Color', 'bookify-pro' ),
							'text_hcolor'       => esc_html__( 'Text hover Color', 'bookify-pro' ),
							'background'        => esc_html__( 'Background', 'bookify-pro' ),
							'active_background' => esc_html__( 'Hover Background', 'bookify-pro' ),
						),
						'default'    => array(
							'text_color'        => '#ffffff',
							'text_hcolor'       => '#5e5e5e',
							'background'        => '#c27b7f',
							'active_background' => '#ffffff',
						),
						'dependency' => array( 'bop_layout_preset|show_post_pagination|post_pagination_type', '!=|==|==', 'carousel_layout|true|ajax_load_more', true ),
					),
					array(
						'id'         => 'pagination_alignment',
						'type'       => 'button_set',
						'title'      => esc_html__( 'Alignment', 'bookify-pro' ),
						'subtitle'   => esc_html__( 'Choose pagination alignment.', 'bookify-pro' ),
						'options'    => array(
							'left'   => wp_kses( __( '<i class="fas fa-align-left" title="Left"></i>', 'bookify-pro' ), array( 'i' => array( 'class' => array() ) ) ),
							'center' => wp_kses( __( '<i class="fas fa-align-center" title="Center"></i>', 'bookify-pro' ), array( 'i' => array( 'class' => array() ) ) ),
							'right'  => wp_kses( __( '<i class="fas fa-align-right" title="Right"></i>', 'bookify-pro' ), array( 'i' => array( 'class' => array() ) ) ),
						),
						'default'    => 'left',
						'dependency' => array( 'bop_layout_preset|show_post_pagination', '!=|==', 'carousel_layout|true', true ),
					),
					array(
						'id'         => 'post_per_page',
						'type'       => 'spinner',
						'title'      => esc_html__( 'Items Per Page', 'bookify-pro' ),
						'subtitle'   => esc_html__( 'Set number of items to show per page.', 'bookify-pro' ),
						'title_help' => esc_html__( 'This value should be lesser than that <strong> Limit </strong> from <strong>Filter Content  </strong> tab.', 'bookify-pro' ),
						'sanitize'   => 'bop_sanitize_number_field',
						'default'    => 12,
						'dependency' => array( 'bop_layout_preset|show_post_pagination', '!=|==', 'carousel_layout|true', true ),
					),
					array(
						'id'         => 'show_preloader',
						'type'       => 'switcher',
						'title'      => esc_html__( 'Preloader', 'bookify-pro' ),
						'subtitle'   => esc_html__( 'Items will be hidden until page load completed.', 'bookify-pro' ),
						'text_on'    => esc_html__( 'Enabled', 'bookify-pro' ),
						'text_off'   => esc_html__( 'Disabled', 'bookify-pro' ),
						'text_width' => 100,
						'default'    => false,
					),
					array(
						'type'    => 'subheading',
						'class'   => 'bop_filter_btn_color hidden',
						'content' => esc_html__( 'Live Filter Button', 'bookify-pro' ),
					),
				), // End of fields array.
			)
		); // Display settings section end.
	}
}
