<?php if ( ! defined( 'ABSPATH' ) ) {
	die;
} // Cannot access directly.

/**
 * The Carousel building class.
 */
class BOP_Carousel {


	/**
	 * Carousel section metabox.
	 *
	 * @param string $prefix The metabox key.
	 * @return void
	 */
	public static function section( $prefix ) {
		BOP::createSection(
			$prefix,
			array(
				'title'  => esc_html__( 'Carousel Controls', 'bookify-pro' ),
				'icon'   => 'fas fa-sliders-h',
				'fields' => array(
					array(
						'id'       => 'bop_carousel_mode',
						'type'     => 'button_set',
						'title'    => esc_html__( 'Carousel Mode', 'bookify-pro' ),
						'subtitle' => esc_html__( 'Choose a mode for the carousel.', 'bookify-pro' ),
						'options'  => array(
							'standard' => esc_html__( 'Standard', 'bookify-pro' ),
							'center'   => esc_html__( 'Center', 'bookify-pro' ),
							'ticker'   => esc_html__( 'Ticker', 'bookify-pro' ),
						),
						'default'  => 'standard',
					),
					array(
						'id'         => 'bop_ticker_speed',
						'type'       => 'spinner',
						'title'      => esc_html__( 'Carousel Speed', 'bookify-pro' ),
						'subtitle'   => esc_html__( 'Set carousel speed in millisecond.', 'bookify-pro' ),
						'sanitize'   => 'bop_sanitize_number_field',
						'default'    => '3000',
						'min'        => 0,
						'max'        => 50000,
						'step'       => 100,
						'unit'       => 'ms',
						'dependency' => array( 'bop_carousel_mode', '==', 'ticker' ),
					),

					array(
						'id'         => 'bop_ticker_slide_width',
						'type'       => 'spinner',
						'title'      => esc_html__( 'Column Width', 'bookify-pro' ),
						'subtitle'   => esc_html__( 'Set a width for the column.', 'bookify-pro' ),
						'sanitize'   => 'bop_sanitize_number_field',
						'default'    => '250',
						'min'        => 0,
						'max'        => 1000,
						'step'       => 10,
						'unit'       => 'px',
						'dependency' => array( 'bop_carousel_mode', '==', 'ticker' ),
					),
					array(
						'id'         => 'bop_autoplay',
						'type'       => 'switcher',
						'title'      => esc_html__( 'AutoPlay', 'bookify-pro' ),
						'subtitle'   => esc_html__( 'Enable/Disable carousel autoplay.', 'bookify-pro' ),
						'text_on'    => esc_html__( 'Enabled', 'bookify-pro' ),
						'text_off'   => esc_html__( 'Disabled', 'bookify-pro' ),
						'text_width' => 94,
						'default'    => true,
						'dependency' => array( 'bop_carousel_mode', '!=', 'ticker' ),
					),
					array(
						'id'         => 'bop_autoplay_speed',
						'type'       => 'spinner',
						'title'      => esc_html__( 'AutoPlay Speed', 'bookify-pro' ),
						'subtitle'   => esc_html__( 'Set autoplay speed in millisecond.', 'bookify-pro' ),
						'sanitize'   => 'bop_sanitize_number_field',
						'default'    => '2000',
						'min'        => 0,
						'max'        => 10000,
						'step'       => 100,
						'unit'       => 'ms',
						'dependency' => array( 'bop_autoplay|bop_carousel_mode', '==|!=', 'true|ticker' ),
					),
					array(
						'id'         => 'bop_carousel_speed',
						'type'       => 'spinner',
						'title'      => esc_html__( 'Carousel Speed', 'bookify-pro' ),
						'subtitle'   => esc_html__( 'Set carousel speed in millisecond.', 'bookify-pro' ),
						'sanitize'   => 'bop_sanitize_number_field',
						'default'    => '600',
						'min'        => 0,
						'max'        => 20000,
						'step'       => 100,
						'unit'       => 'ms',
						'dependency' => array( 'bop_carousel_mode', '!=', 'ticker' ),
					),
					array(
						'id'         => 'bop_pause_hover',
						'type'       => 'switcher',
						'title'      => esc_html__( 'Pause on Hover', 'bookify-pro' ),
						'subtitle'   => esc_html__( 'Enable/Disable carousel stop on hover.', 'bookify-pro' ),
						'text_on'    => esc_html__( 'Enabled', 'bookify-pro' ),
						'text_off'   => esc_html__( 'Disabled', 'bookify-pro' ),
						'text_width' => 94,
						'default'    => true,
						'dependency' => array( 'bop_autoplay', '==', 'true' ),
					),
					array(
						'id'         => 'bop_infinite_loop',
						'type'       => 'switcher',
						'title'      => esc_html__( 'Infinite Loop', 'bookify-pro' ),
						'subtitle'   => esc_html__( 'Enable/Disable carousel infinite loop.', 'bookify-pro' ),
						'text_on'    => esc_html__( 'Enabled', 'bookify-pro' ),
						'text_off'   => esc_html__( 'Disabled', 'bookify-pro' ),
						'text_width' => 94,
						'default'    => true,
						'dependency' => array( 'bop_carousel_mode', '!=', 'ticker' ),
					),
					array(
						'id'         => 'bop_lazy_load',
						'type'       => 'switcher',
						'title'      => esc_html__( 'Lazy Load', 'bookify-pro' ),
						'subtitle'   => esc_html__( 'Enable/Disable lazy load.', 'bookify-pro' ),
						'text_on'    => esc_html__( 'Enabled', 'bookify-pro' ),
						'text_off'   => esc_html__( 'Disabled', 'bookify-pro' ),
						'text_width' => 94,
						'default'    => true,
						'dependency' => array( 'bop_carousel_mode|bop_slide_effect', '!=|not-any', 'ticker|cube,flip' ),
					),
					array(
						'id'       => 'bop_carousel_direction',
						'type'     => 'button_set',
						'title'    => esc_html__( 'Carousel Direction', 'bookify-pro' ),
						'subtitle' => esc_html__( 'Choose a carousel direction.', 'bookify-pro' ),
						'options'  => array(
							'ltr' => esc_html__( 'Right to Left', 'bookify-pro' ),
							'rtl' => esc_html__( 'Left to Right', 'bookify-pro' ),
						),
						'default'  => 'ltr',
					),
					array(
						'id'         => 'bop_slide_effect',
						'type'       => 'select',
						'title'      => esc_html__( 'Transition Effect', 'bookify-pro' ),
						'subtitle'   => esc_html__( 'Select a slide transition effect.', 'bookify-pro' ),
						'help'       => esc_html__( 'Fade, cube, and flip transition effects work only for the single column view.', 'bookify-pro' ),
						'options'    => array(
							'slide'     => esc_html__( 'Slide', 'bookify-pro' ),
							'fade'      => esc_html__( 'Fade', 'bookify-pro' ),
							'coverflow' => esc_html__( 'Coverflow', 'bookify-pro' ),
							'cube'      => esc_html__( 'Cube', 'bookify-pro' ),
							'flip'      => esc_html__( 'Flip', 'bookify-pro' ),
						),
						'default'    => 'slide',
						'dependency' => array( 'bop_carousel_mode', '!=', 'ticker' ),
					),
					array(
						'id'         => 'bop_number_of_row',
						'type'       => 'column',
						'title'      => esc_html__( 'Row', 'bookify-pro' ),
						'subtitle'   => esc_html__( 'Set number of row in different devices for responsive view.', 'bookify-pro' ),
						'default'    => array(
							'lg_desktop'       => '1',
							'desktop'          => '1',
							'tablet'           => '1',
							'mobile_landscape' => '1',
							'mobile'           => '1',
						),
						'min'        => '1',
						'dependency' => array( 'bop_carousel_mode', '==', 'standard', true ),
						'help'       => esc_html__( 'When multiple <b>Row</b> is set, the above two options <b>Infinite Loop</b> and <b>Auto Height</b> won\'t work properly.', 'bookify-pro' ),
					),
					array(
						'type'       => 'subheading',
						'content'    => esc_html__( 'Navigation', 'bookify-pro' ),
						'dependency' => array( 'bop_carousel_mode', '!=', 'ticker' ),
					),
					// Navigation Settings.
					array(
						'id'         => 'bop_navigation',
						'type'       => 'button_set',
						'title'      => esc_html__( 'Navigation', 'bookify-pro' ),
						'subtitle'   => esc_html__( 'Show/Hide carousel navigation.', 'bookify-pro' ),
						'options'    => array(
							'show'           => esc_html__( 'Show', 'bookify-pro' ),
							'hide'           => esc_html__( 'Hide', 'bookify-pro' ),
							'hide_on_mobile' => esc_html__( 'Hide on Mobile', 'bookify-pro' ),
						),
						'default'    => 'show',
						'dependency' => array( 'bop_carousel_mode', '!=', 'ticker' ),
					),
					array(
						'id'         => 'bop_carousel_nav_position',
						'type'       => 'select',
						'title'      => esc_html__( 'Select Position', 'bookify-pro' ),
						'subtitle'   => esc_html__( 'Select a position for the navigation arrows.', 'bookify-pro' ),
						'options'    => array(
							'top_right'                   => esc_html__( 'Top right', 'bookify-pro' ),
							'top_center'                  => esc_html__( 'Top center', 'bookify-pro' ),
							'top_left'                    => esc_html__( 'Top left', 'bookify-pro' ),
							'bottom_left'                 => esc_html__( 'Bottom left', 'bookify-pro' ),
							'bottom_center'               => esc_html__( 'Bottom center', 'bookify-pro' ),
							'bottom_right'                => esc_html__( 'Bottom right', 'bookify-pro' ),
							'vertically_center_outer'     => esc_html__( 'Vertically center outer', 'bookify-pro' ),
							'vertical_center_inner'       => esc_html__( 'Vertically center inner', 'bookify-pro' ),
							'vertical_center_inner_hover' => esc_html__( 'Vertically center inner on hover', 'bookify-pro' ),
						),
						'default'    => 'top_right',
						'dependency' => array( 'bop_navigation|bop_carousel_mode', '!=|!=', 'hide|ticker' ),
					),
					array(
						'id'         => 'navigation_icons',
						'type'       => 'button_set',
						'title'      => esc_html__( 'Choose an Icon', 'bookify-pro' ),
						'subtitle'   => esc_html__( 'Choose a carousel navigation icon.', 'bookify-pro' ),
						'options'    => array(
							'fa-angle'        => '<i class="fas fa-angle-right"></i>',
							'fa-angle-double' => '<i class="fas fa-angle-right"></i>',
							'fa-arrow'        => '<i class="fas fa-arrow-right"></i>',
							'fa-caret'        => '<i class="fas fa-caret-right"></i>',
							'fa-chevron'      => '<i class="fas fa-chevron-right"></i>',
						),
						'default'    => 'fa-angle',
						'dependency' => array( 'bop_navigation|bop_carousel_mode', '!=|!=', 'hide|ticker' ),
					),
					array(
						'id'         => 'bop_nav_icon_size',
						'type'       => 'spinner',
						'title'      => esc_html__( 'Arrow Icon Size', 'bookify-pro' ),
						'subtitle'   => esc_html__( 'Set a size for arrow icon.', 'bookify-pro' ),
						'sanitize'   => 'bop_sanitize_number_field',
						'default'    => '18',
						'min'        => 0,
						'max'        => 100,
						'unit'       => 'px',
						'dependency' => array( 'bop_navigation|bop_carousel_mode', '!=|!=', 'hide|ticker' ),
					),
					array(
						'id'         => 'navigation_icons_border_radius',
						'type'       => 'spacing',
						'title'      => esc_html__( 'Navigation Border Radius', 'bookify-pro' ),
						'subtitle'   => esc_html__( 'Set border radius for the navigation icons.', 'bookify-pro' ),
						'sanitize'   => 'bop_sanitize_number_array_field',
						'all'        => true,
						'min'        => 0,
						'max'        => 100,
						'units'      => array( 'px', '%' ),
						'default'    => array(
							'all' => '0',
						),
						'dependency' => array( 'bop_navigation|bop_carousel_mode', '!=|!=', 'hide|ticker' ),
					),
					array(
						'id'         => 'bop_nav_colors',
						'type'       => 'color_group',
						'title'      => esc_html__( 'Navigation Color', 'bookify-pro' ),
						'subtitle'   => esc_html__( 'Set color for the carousel navigation.', 'bookify-pro' ),
						'options'    => array(
							'color'              => esc_html__( 'Color', 'bookify-pro' ),
							'hover-color'        => esc_html__( 'Hover Color', 'bookify-pro' ),
							'bg'                 => esc_html__( 'Background', 'bookify-pro' ),
							'hover-bg'           => esc_html__( 'Hover Background', 'bookify-pro' ),
							'border-color'       => esc_html__( 'Border', 'bookify-pro' ),
							'hover-border-color' => esc_html__( 'Hover Border', 'bookify-pro' ),
						),
						'default'    => array(
							'color'              => '#aaa',
							'hover-color'        => '#fff',
							'bg'                 => '#fff',
							'hover-bg'           => '#876585',
							'border-color'       => '#aaa',
							'hover-border-color' => '#876585',
						),
						'dependency' => array( 'bop_navigation|bop_carousel_mode', '!=|!=', 'hide|ticker' ),
					),

					// Pagination Settings.
					array(
						'type'       => 'subheading',
						'content'    => esc_html__( 'Pagination', 'bookify-pro' ),
						'dependency' => array( 'bop_carousel_mode', '!=', 'ticker' ),
					),
					array(
						'id'         => 'bop_pagination',
						'type'       => 'button_set',
						'title'      => esc_html__( 'Pagination', 'bookify-pro' ),
						'subtitle'   => esc_html__( 'Show/Hide carousel pagination.', 'bookify-pro' ),
						'options'    => array(
							'show'           => esc_html__( 'Show', 'bookify-pro' ),
							'hide'           => esc_html__( 'Hide', 'bookify-pro' ),
							'hide_on_mobile' => esc_html__( 'Hide on Mobile', 'bookify-pro' ),
						),
						'default'    => 'show',
						'dependency' => array( 'bop_carousel_mode', '!=', 'ticker' ),
					),
					array(
						'id'         => 'bullet_types',
						'type'       => 'button_set',
						'title'      => esc_html__( 'Pagination Type', 'bookify-pro' ),
						'subtitle'   => esc_html__( 'Choose a type for pagination.', 'bookify-pro' ),
						'options'    => array(
							'dots'   => esc_html__( 'Dots', 'bookify-pro' ),
							'number' => esc_html__( 'Number', 'bookify-pro' ),
						),
						'default'    => 'dots',
						'dependency' => array( 'bop_pagination|bop_carousel_mode', '!=|!=', 'hide|ticker' ),
					),
					array(
						'id'         => 'bop_pagination_color_set',
						'type'       => 'fieldset',
						'class'      => 'bop-pagination-color-set',
						'title'      => esc_html__( 'Pagination Color', 'bookify-pro' ),
						'subtitle'   => esc_html__( 'Set color for the carousel pagination.', 'bookify-pro' ),
						'fields'     => array(
							array(
								'id'         => 'bop_pagination_color',
								'type'       => 'color_group',
								'options'    => array(
									'color'        => esc_html__( 'Color', 'bookify-pro' ),
									'active-color' => esc_html__( 'Active Color', 'bookify-pro' ),
								),
								'default'    => array(
									'color'        => '#cccccc',
									'active-color' => '#876585',
								),
								'dependency' => array( 'bullet_types', '==', 'dots', true ),
							),
							array(
								'id'         => 'bop_pagination_number_color',
								'type'       => 'color_group',
								'options'    => array(
									'color'       => esc_html__( 'Color', 'bookify-pro' ),
									'hover-color' => esc_html__( 'Hover Color', 'bookify-pro' ),
									'bg'          => esc_html__( 'Background', 'bookify-pro' ),
									'hover-bg'    => esc_html__( 'Hover Background', 'bookify-pro' ),
								),
								'default'    => array(
									'color'       => '#ffffff',
									'hover-color' => '#ffffff',
									'bg'          => '#444444',
									'hover-bg'    => '#876585',
								),
								'dependency' => array( 'bullet_types', '==', 'number', true ),
							),
						),
						'dependency' => array( 'bop_pagination|bop_carousel_mode', '!=|!=', 'hide|ticker' ),
					),
					array(
						'id'         => 'bop_dynamicBullets',
						'type'       => 'checkbox',
						'title'      => esc_html__( 'Dynamic Pagination', 'bookify-pro' ),
						'subtitle'   => esc_html__( 'Check to show dynamic pagination.', 'bookify-pro' ),
						'default'    => false,
						'dependency' => array( 'bop_pagination|bop_carousel_mode', '!=|!=', 'hide|ticker' ),
					),
					array(
						'id'         => 'bop_slides_to_scroll',
						'type'       => 'column',
						'title'      => esc_html__( 'Slide To Scroll', 'bookify-pro' ),
						'subtitle'   => esc_html__( 'Number of post(s) to scroll at a time.', 'bookify-pro' ),
						'unit'       => false,
						'default'    => array(
							'lg_desktop' => '1',
							'desktop'    => '1',
							'laptop'     => '1',
							'tablet'     => '1',
							'mobile'     => '1',
						),
						'dependency' => array( 'bop_carousel_mode', '!=', 'ticker' ),
						'help'       => wp_kses(
							esc_html__( '<i class="fas fa-television"></i> <b> Large Desktop </b> - is larger than 1200px,<br><i class="fas fa-desktop"></i> <b>Desktop</b> - size is larger than 992px,<br> <i class="fas fa-tablet-alt"></i> <b>Tablet</b> - Size is larger than 768,<br> <i class="fas fa-mobile-alt"></i> <b> Mobile Landscape </b> - size is larger than 576px.,<br> <i class="fas fa-mobile-alt"></i> <b> Mobile </b> - size is smaller than 576px.', 'bookify-pro' ),
							array(
								'i'  => array( 'class' => array() ),
								'br' => array(),
							)
						),
					),
					// Miscellaneous Settings.
					array(
						'type'       => 'subheading',
						'content'    => esc_html__( 'Miscellaneous', 'bookify-pro' ),
						'dependency' => array( 'bop_carousel_mode', '!=', 'ticker' ),
					),
					array(
						'id'         => 'bop_adaptive_height',
						'type'       => 'switcher',
						'title'      => esc_html__( 'Adaptive Carousel Height', 'bookify-pro' ),
						'subtitle'   => esc_html__( 'Dynamically adjust post carousel height based on each slide\'s height.', 'bookify-pro' ),
						'default'    => false,
						'text_on'    => esc_html__( 'Enabled', 'bookify-pro' ),
						'text_off'   => esc_html__( 'Disabled', 'bookify-pro' ),
						'text_width' => 94,
						'dependency' => array( 'bop_carousel_mode|bop_slide_effect', '!=|not-any', 'ticker|flip,cube' ),
					),
					array(
						'id'         => 'bop_accessibility',
						'type'       => 'switcher',
						'title'      => esc_html__( 'Tab and Key Navigation', 'bookify-pro' ),
						'subtitle'   => esc_html__( 'Enable/Disable carousel scroll with tab and keyboard.', 'bookify-pro' ),
						'default'    => true,
						'text_on'    => esc_html__( 'Enabled', 'bookify-pro' ),
						'text_off'   => esc_html__( 'Disabled', 'bookify-pro' ),
						'text_width' => 94,

						'dependency' => array( 'bop_carousel_mode', '!=', 'ticker' ),
					),
					array(
						'id'         => 'touch_swipe',
						'type'       => 'switcher',
						'title'      => esc_html__( 'Touch Swipe', 'bookify-pro' ),
						'subtitle'   => esc_html__( 'Enable/Disable touch swipe mode.', 'bookify-pro' ),
						'text_on'    => esc_html__( 'Enabled', 'bookify-pro' ),
						'text_off'   => esc_html__( 'Disabled', 'bookify-pro' ),
						'text_width' => 94,
						'default'    => true,
						'dependency' => array( 'bop_carousel_mode', '!=', 'ticker' ),
					),
					array(
						'id'         => 'slider_draggable',
						'type'       => 'switcher',
						'title'      => esc_html__( 'Mouse Draggable', 'bookify-pro' ),
						'subtitle'   => esc_html__( 'Enable/Disable mouse draggable mode.', 'bookify-pro' ),
						'text_on'    => esc_html__( 'Enabled', 'bookify-pro' ),
						'text_off'   => esc_html__( 'Disabled', 'bookify-pro' ),
						'text_width' => 94,
						'default'    => true,
						'dependency' => array( 'bop_carousel_mode', '!=', 'ticker' ),
					),
					array(
						'id'         => 'slider_mouse_wheel',
						'type'       => 'switcher',
						'title'      => esc_html__( 'Mouse Wheel', 'bookify-pro' ),
						'subtitle'   => esc_html__( 'Enable/Disable mouse wheel mode.', 'bookify-pro' ),
						'text_on'    => esc_html__( 'Enabled', 'bookify-pro' ),
						'text_off'   => esc_html__( 'Disabled', 'bookify-pro' ),
						'text_width' => 94,
						'default'    => false,
						'dependency' => array( 'bop_carousel_mode', '!=', 'ticker' ),
					),
				), // End of fields array.
			)
		); // Carousel Controls section end.
	}
}
