<?php
/**
 * The Filter Post Meta-box configurations.
 *
 * @package Bookify_pro
 * @subpackage admin
 */

if ( ! defined( 'ABSPATH' ) ) {
	die; } // Cannot access pages directly.

/**
 * The Filter post building class.
 */
class BOP_FilterPost {

	/**
	 * Filter Post section metabox.
	 *
	 * @param string $prefix The metabox key.
	 * @return void
	 */
	public static function section( $prefix ) {
		BOP::createSection(
			$prefix,
			array(
				'title'  => esc_html__( 'Filter Content', 'bookify-pro' ),
				'icon'   => 'fas fa-filter',
				'fields' => array(

					array(
						'id'          => 'bop_include_only_posts',
						'type'        => 'select',
						'title'       => esc_html__( 'Include Only', 'bookify-pro' ),
						'subtitle'    => esc_html__( 'Choose posts to include by title.', 'bookify-pro' ),
						'options'     => 'posts',
						'ajax'        => true,
						'sortable'    => true,
						'chosen'      => true,
						'class'       => 'ta_bop_include_only_posts',
						'multiple'    => true,
						'placeholder' => esc_html__( 'Choose posts', 'bookify-pro' ),
						'query_args'  => array(
							'post_type'     => 'bookify',
							'cache_results' => false,
							'no_found_rows' => true,
						),
					),
					array(
						'id'       => 'bop_exclude_post_set',
						'type'     => 'fieldset',
						'title'    => esc_html__( 'Exclude', 'bookify-pro' ),
						'subtitle' => esc_html__( 'Choose posts to exclude by title.', 'bookify-pro' ),
						'class'    => 'ta_bop_exclude_post_set',
						'fields'   => array(
							array(
								'id'          => 'bop_exclude_posts',
								'type'        => 'select',
								'options'     => 'posts',
								'chosen'      => true,
								'class'       => 'ta_bop_exclude_posts',
								'multiple'    => true,
								'ajax'        => true,
								'placeholder' => esc_html__( 'Choose posts to exclude', 'bookify-pro' ),
								'query_args'  => array(
									'post_type'     => 'bookify',
									'cache_results' => false,
									'no_found_rows' => true,
								),
								'dependency'  => array( 'bop_include_only_posts', '==', '', true ),
							),
							array(
								'id'      => 'bop_exclude_too',
								'type'    => 'checkbox',
								'class'   => 'ta_bop_exclude_too',
								'options' => array(
									'current'            => esc_html__( 'Current Post', 'bookify-pro' ),
									'password_protected' => esc_html__( 'Password Protected Posts', 'bookify-pro' ),
									'children'           => esc_html__( 'Children Posts', 'bookify-pro' ),
								),
							),
						),
					),
					array(
						'id'       => 'bop_post_limit',
						'title'    => esc_html__( 'Limit', 'bookify-pro' ),
						'type'     => 'spinner',
						'subtitle' => esc_html__( 'Number of total items to display. Leave it empty to show all found items.', 'bookify-pro' ),
						'sanitize' => 'bop_sanitize_number_field',
						'default'  => '15',
						'min'      => 1,
					),
					array(
						'id'       => 'bop_post_offset',
						'type'     => 'spinner',
						'title'    => esc_html__( 'Offset', 'bookify-pro' ),
						'subtitle' => esc_html__( 'Number of items to skip.', 'bookify-pro' ),
						'sanitize' => 'bop_sanitize_number_field',
						'default'  => 0,
					),
					array(
						'type'    => 'subheading',
						'content' => esc_html__( 'Advanced Filtering', 'bookify-pro' ),
					),
					array(
						'id'       => 'bop_advanced_filter',
						'type'     => 'checkbox',
						'class'    => 'bop_column_2 bop_advanced_filter',
						'title'    => esc_html__( 'Filter by', 'bookify-pro' ),
						'subtitle' => esc_html__( 'Check the option(s) to filter by.', 'bookify-pro' ),
						'options'  => array(
							'taxonomy' => esc_html__( 'Taxonomy', 'bookify-pro' ),
							'author'   => esc_html__( 'Author', 'bookify-pro' ),
							'sortby'   => esc_html__( 'Sort By', 'bookify-pro' ),
							'status'   => esc_html__( 'Status', 'bookify-pro' ),
							'date'     => esc_html__( 'Date', 'bookify-pro' ),
							'keyword'  => esc_html__( 'Keyword', 'bookify-pro' ),
						),
					),
					array(
						'id'         => 'bop_filter_by_taxonomy',
						'type'       => 'accordion',
						'class'      => 'padding-t-0 bop-opened-accordion',
						'accordions' => array(
							array(
								'title'  => esc_html__( 'Taxonomy', 'bookify-pro' ),
								'icon'   => 'fas fa-folder-open',
								'fields' => array(
									// The Group Fields.
									array(
										'id'     => 'bop_taxonomy_and_terms',
										'type'   => 'group',
										'class'  => 'bop_taxonomy_terms_group bop_custom_group_design',
										'accordion_title_auto' => true,
										'fields' => array(
											array(
												'id'      => 'bop_select_taxonomy',
												'type'    => 'select',
												'title'   => esc_html__( 'Select Taxonomy', 'bookify-pro' ),
												'class'   => 'ta_bop_post_taxonomy',
												'options' => 'taxonomy',
												'query_args' => array(
													'type' => 'post',
												),
												'attributes' => array(
													'style' => 'width: 200px;',
												),
												'empty_message' => esc_html__( 'No taxonomies found.', 'bookify-pro' ),
											),
											array(
												'id'      => 'hide_taxonomy_name',
												'type'    => 'checkbox',
												'title'   => esc_html__( 'Hide Taxonomy Name', 'bookify-pro' ),
												'class'   => 'hide_taxonomy_name',
												'default' => false,
											),
											array(
												'id'       => 'bop_select_terms',
												'type'     => 'select',
												'title'    => esc_html__( 'Choose Term(s)', 'bookify-pro' ),
												'title_help' => esc_html__( 'Choose the taxonomy term(s) to show the posts from. Leave empty to show all found taxonomy term(s).', 'bookify-pro' ),
												'options'  => 'terms',
												'class'    => 'ta_bop_taxonomy_terms',
												'width'    => '300px',
												'multiple' => true,
												'sortable' => true,
												'empty_message' => esc_html__( 'No terms found.', 'bookify-pro' ),
												'placeholder' => esc_html__( 'Select Term(s)', 'bookify-pro' ),
												'chosen'   => true,
											),
											array(
												'id'      => 'bop_taxonomy_term_operator',
												'type'    => 'select',
												'title'   => esc_html__( 'Operator', 'bookify-pro' ),
												'options' => array(
													'IN'  => esc_html__( 'IN', 'bookify-pro' ),
													'AND' => esc_html__( 'AND', 'bookify-pro' ),
													'NOT IN' => esc_html__( 'NOT IN', 'bookify-pro' ),
												),
												'default' => 'IN',
												'title_help' => esc_html__( 'IN - Show posts which associate with one or more terms<br>AND - Show posts which match all terms<br>NOT IN - Show posts which don\'t match the terms', 'bookify-pro' ),
											),
											array(
												'id'    => 'add_filter_post',
												'type'  => 'checkbox',
												'title' => esc_html__( 'Add to Ajax Live Filters', 'bookify-pro' ),
												'title_help' => esc_html__( 'Check to add ajax live filters.', 'bookify-pro' ),
											),
											array(
												'id'     => 'ajax_filter_options',
												'type'   => 'fieldset',
												'title'  => esc_html__( 'Ajax Live Filters', 'bookify-pro' ),
												'dependency' => array( 'add_filter_post', '==', 'true' ),
												'fields' => array(
													array(
														'id'            => 'ajax_filter_style',
														'type'          => 'select',
														'title'         => esc_html__( 'Filter Type', 'bookify-pro' ),
														'title_help'    => esc_html__( 'Select a type for live filter.', 'bookify-pro' ),
														'options'       => array(
															'fl_dropdown'   => esc_html__( 'Dropdown', 'bookify-pro' ),
															'fl_radio'      => esc_html__( 'Radio', 'bookify-pro' ),
															'fl_checkbox'    => esc_html__( 'Checkbox', 'bookify-pro' ),
															'fl_btn'        => esc_html__( 'Button', 'bookify-pro' ),
														),
														'default'  => 'fl_btn',
													),
													array(
														'id'            => 'bop_filter_btn_color',
														'type'          => 'color_group',
														'title'         => esc_html__( 'Button Color', 'bookify-pro' ),
														'dependency'    => array( 'ajax_filter_style', '==', 'fl_btn' ),
														'options'       => array(
															'text_color'        => esc_html__( 'Text Color', 'bookify-pro' ),
															'text_acolor'       => esc_html__( 'Text Hover', 'bookify-pro' ),
															'border_color'      => esc_html__( 'Border Color', 'bookify-pro' ),
															'border_acolor'     => esc_html__( 'Border Hover', 'bookify-pro' ),
															'background'        => esc_html__( 'Background', 'bookify-pro' ),
															'active_background' => esc_html__( 'Active/Hover BG', 'bookify-pro' ),
														),
														'default'  => array(
															'text_color'        => '#5e5e5e',
															'text_acolor'       => '#ffffff',
															'border_color'      => '#bbbbbb',
															'border_acolor'     => '#c27b7f',
															'background'        => '#ffffff',
															'active_background' => '#c27b7f',
														),
													),
													array(
														'id'         => 'bop_margin_between_button',
														'type'       => 'spacing',
														'title'      => esc_html__( 'Margin Between Buttons', 'bookify-pro' ),
														'sanitize'   => 'bop_sanitize_number_array_field',
														'subtitle'   => esc_html__( 'Set margin between buttons.', 'bookify-pro' ),
														'units'      => array( 'px' ),
														'default'    => array(
															'top'    => '0',
															'right'  => '8',
															'bottom' => '8',
															'left'   => '0',
															'unit'   => 'px',
														),
														'dependency' => array( 'ajax_filter_style', '==', 'fl_btn' ),
													),
													array(
														'id'       => 'ajax_filter_label',
														'type'     => 'text',
														'title'    => esc_html__( 'Label', 'bookify-pro' ),
														'title_help' => esc_html__( 'Type live filter label.', 'bookify-pro' ),
													),
													array(
														'id'            => 'ajax_rename_all_text',
														'type'          => 'text',
														'title'         => esc_html__( 'Rename "All" Text', 'bookify-pro' ),
														'title_help'    => esc_html__( 'Leave it empty to hide "All" text.', 'bookify-pro' ),
														'default'       => esc_html__( 'All', 'bookify-pro' ),
														'dependency'    => array( 'ajax_filter_style', '!=', 'fl_checkbox' ),
													),
													array(
														'id'            => 'ajax_hide_empty',
														'type'          => 'checkbox',
														'title'         => esc_html__( 'Hide Empty Term(s)', 'bookify-pro' ),
														'title_help'    => esc_html__( 'Check to hide empty terms.', 'bookify-pro' ),
													),
													array(
														'id'            => 'ajax_show_count',
														'type'          => 'checkbox',
														'title'         => esc_html__( 'Show Post Count', 'bookify-pro' ),
														'title_help'    => esc_html__( 'Check to show post count.', 'bookify-pro' ),
														'default'       => false,
													),
													array(
														'id'            => 'bop_live_filter_align',
														'type'          => 'button_set',
														'title'         => esc_html__( 'Alignment', 'bookify-pro' ),
														'options'       => array(
															'left'      => wp_kses( __( '<i class="fas fa-align-left" title="Left"></i>', 'bookify-pro' ), array( 'i' => array( 'class' => array() ) ) ),
															'center' => wp_kses( __( '<i class="fas fa-align-center" title="Center"></i>', 'bookify-pro' ), array( 'i' => array( 'class' => array() ) ) ),
															'right'  => wp_kses( __( '<i class="fas fa-align-right" title="Right"></i>', 'bookify-pro' ), array( 'i' => array( 'class' => array() ) ) ),
														),
														'default'  => 'center',
													),
												),
											),

										),
									), // Group field end.
									array(
										'id'         => 'bop_taxonomies_relation',
										'type'       => 'select',
										'title'      => esc_html__( 'Relation', 'bookify-pro' ),
										'class'      => 'bop_relate_among_taxonomies',
										'options'    => array(
											'AND' => esc_html__( 'AND', 'bookify-pro' ),
											'OR'  => esc_html__( 'OR', 'bookify-pro' ),
										),
										'default'    => 'AND',
										'title_help' => esc_html__( 'The logical relationship between/among above taxonomies.', 'bookify-pro' ),
									),

								), // Fields array.
							),
						), // Accordions end.
						'dependency' => array( 'bop_advanced_filter', 'not-any', 'author,sortby,custom_field,status,date,keyword' ),
					),
					array(
						'id'         => 'bop_filter_by_author',
						'type'       => 'accordion',
						'class'      => 'padding-t-0 bop-opened-accordion',
						'accordions' => array(
							array(
								'title'  => esc_html__( 'Author', 'bookify-pro' ),
								'icon'   => 'fas fa-user',
								'fields' => array(
									array(
										'id'      => 'bop_select_author_by',
										'type'    => 'checkbox',
										'title'   => esc_html__( 'Post by Author', 'bookify-pro' ),
										'options' => 'users',
									),
									array(
										'id'         => 'add_author_filter_post',
										'type'       => 'checkbox',
										'title'      => esc_html__( 'Add to Ajax Live Filters', 'bookify-pro' ),
										'title_help' => esc_html__( 'Check to add ajax live filters.', 'bookify-pro' ),
										'dependency' => array( 'bop_layout_preset', '!=', 'filter_layout', true ),
									),
									array(
										'id'         => 'ajax_filter_options',
										'type'       => 'fieldset',
										'title'      => esc_html__( 'Ajax Live Filters', 'bookify-pro' ),
										'dependency' => array( 'add_author_filter_post', '==', 'true', true ),
										'fields'     => array(
											array(
												'id'      => 'ajax_filter_style',
												'type'    => 'select',
												'title'   => esc_html__( 'Filter Type', 'bookify-pro' ),
												'title_help' => esc_html__( 'Select a type for live filter.', 'bookify-pro' ),
												'options' => array(
													'fl_dropdown' => esc_html__( 'Dropdown', 'bookify-pro' ),
													'fl_radio'    => esc_html__( 'Radio', 'bookify-pro' ),
													'fl_btn'      => esc_html__( 'Button', 'bookify-pro' ),
												),
												'default' => 'fl_btn',
											),
											array(
												'id'      => 'bop_author_btn_color',
												'type'    => 'color_group',
												'title'   => esc_html__( 'Button Color', 'bookify-pro' ),
												'dependency' => array( 'ajax_filter_style', '==', 'fl_btn' ),
												'options' => array(
													'text_color'        => esc_html__( 'Text Color', 'bookify-pro' ),
													'text_acolor'       => esc_html__( 'Text Hover', 'bookify-pro' ),
													'border_color'      => esc_html__( 'Border Color', 'bookify-pro' ),
													'border_acolor'     => esc_html__( 'Border Hover', 'bookify-pro' ),
													'background'        => esc_html__( 'Background', 'bookify-pro' ),
													'active_background' => esc_html__( 'Active/Hover BG', 'bookify-pro' ),
												),
												'default' => array(
													'text_color'        => '#5e5e5e',
													'text_acolor'       => '#ffffff',
													'border_color'      => '#bbbbbb',
													'border_acolor'     => '#c27b7f',
													'background'        => '#ffffff',
													'active_background' => '#c27b7f',
												),
											),
											array(
												'id'       => 'author_margin_between_button',
												'type'     => 'spacing',
												'title'    => esc_html__( 'Margin Between Buttons', 'bookify-pro' ),
												'sanitize' => 'bop_sanitize_number_array_field',
												'subtitle' => esc_html__( 'Set margin between buttons.', 'bookify-pro' ),
												'units'    => array( 'px' ),
												'default'  => array(
													'top'  => '0',
													'right' => '8',
													'bottom' => '8',
													'left' => '0',
													'unit' => 'px',
												),
												'dependency' => array( 'ajax_filter_style', '==', 'fl_btn' ),
											),
											array(
												'id'    => 'ajax_filter_label',
												'type'  => 'text',
												'title' => esc_html__( 'Label', 'bookify-pro' ),
												'title_help' => esc_html__( 'Type live filter label.', 'bookify-pro' ),
											),
											array(
												'id'      => 'ajax_rename_all_text',
												'type'    => 'text',
												'title'   => esc_html__( 'Rename "All" Text', 'bookify-pro' ),
												'title_help' => esc_html__( 'Rename "All" text.', 'bookify-pro' ),
												'default' => esc_html__( 'All', 'bookify-pro' ),
											),
											array(
												'id'    => 'ajax_hide_empty',
												'type'  => 'checkbox',
												'title' => esc_html__( 'Hide Empty author', 'bookify-pro' ),
												'title_help' => esc_html__( 'Check to hide empty author.', 'bookify-pro' ),
											),
											array(
												'id'    => 'ajax_show_count',
												'type'  => 'checkbox',
												'title' => esc_html__( 'Show Post Count', 'bookify-pro' ),
												'title_help' => esc_html__( 'Check to show post count.', 'bookify-pro' ),
											),
											array(
												'id'      => 'bop_live_filter_align',
												'type'    => 'button_set',
												'title'   => esc_html__( 'Alignment', 'bookify-pro' ),
												'options' => array(
													'left' => wp_kses( __( '<i class="fas fa-align-left" title="Left"></i>', 'bookify-pro' ), array( 'i' => array( 'class' => array() ) ) ),
													'center' => wp_kses( __( '<i class="fas fa-align-center" title="Center"></i>', 'bookify-pro' ), array( 'i' => array( 'class' => array() ) ) ),
													'right' => wp_kses( __( '<i class="fas fa-align-right" title="Right"></i>', 'bookify-pro' ), array( 'i' => array( 'class' => array() ) ) ),
												),
												'default' => 'center',
											),
										),
									),
									array(
										'id'      => 'bop_select_author_not_by',
										'type'    => 'checkbox',
										'title'   => esc_html__( 'Post Not by Author ', 'bookify-pro' ),
										'options' => 'users',
									),
								),
							),
						),
						'dependency' => array( 'bop_advanced_filter', 'not-any', 'taxonomy,sortby,custom_field,status,date,keyword' ),
					),
					array(
						'id'         => 'bop_filter_by_order',
						'type'       => 'accordion',
						'class'      => 'padding-t-0 bop-opened-accordion',
						'accordions' => array(
							array(
								'title'  => esc_html__( 'Sort By', 'bookify-pro' ),
								'icon'   => 'fas fa-sort',
								'fields' => array(
									array(
										'id'      => 'bop_select_filter_orderby',
										'type'    => 'select',
										'title'   => esc_html__( 'Order by', 'bookify-pro' ),
										'options' => array(
											'ID'           => esc_html__( 'ID', 'bookify-pro' ),
											'title'        => esc_html__( 'Title', 'bookify-pro' ),
											'date'         => esc_html__( 'Date', 'bookify-pro' ),
											'modified'     => esc_html__( 'Modified date', 'bookify-pro' ),
											'post_slug'    => esc_html__( 'Post slug', 'bookify-pro' ),
											'post_type'    => esc_html__( 'Post type', 'bookify-pro' ),
											'rand'         => esc_html__( 'Random', 'bookify-pro' ),
											'menu_order'   => esc_html__( 'Menu order', 'bookify-pro' ),
											'author'       => esc_html__( 'Author', 'bookify-pro' ),
											'most_liked'   => esc_html__( 'Most Liked', 'bookify-pro' ),
											'most_viewed'  => esc_html__( 'Most Viewed', 'bookify-pro' ),
											'custom_field' => esc_html__( 'Custom Field', 'bookify-pro' ),
										),
										'default' => 'date',
									),
									array(
										'id'         => 'orderby_custom_field_options',
										'type'       => 'fieldset',
										'title'      => esc_html__( 'Order by Custom Field', 'bookify-pro' ),
										'dependency' => array( 'bop_select_filter_orderby', '==', 'custom_field', true ),
										'fields'     => array(
											array(
												'id'      => 'bop_select_custom_field_key',
												'type'    => 'select',
												'title'   => esc_html__( 'Custom Fields Keys', 'bookify-pro' ),
												'title_help' => esc_html__( 'Select custom fields key.', 'bookify-pro' ),
												'options' => 'custom_fields',
												'chosen'  => true,
												'attributes' => array(
													'style' => 'width: 200px;',
												),
												'empty_message' => esc_html__( 'No custom field keys found.', 'bookify-pro' ),
											),
											array(
												'id'      => 'bop_select_custom_field_value_type',
												'type'    => 'select',
												'title'   => esc_html__( 'Value Type', 'bookify-pro' ),
												'title_help' => esc_html__( 'Select a value type.', 'bookify-pro' ),
												'options' => array(
													'CHAR' => esc_html__( 'Text', 'bookify-pro' ),
													'NUMERIC' => esc_html__( 'Number', 'bookify-pro' ),
													'DATE' => esc_html__( 'Date', 'bookify-pro' ),
													'BOOLEAN' => esc_html__( 'True/False', 'bookify-pro' ),
												),
												'default' => 'NUMERIC',
											),
										),
									),
									array(
										'id'         => 'add_orderby_filter_post',
										'type'       => 'checkbox',
										'title'      => esc_html__( 'Add to Ajax Live Filters', 'bookify-pro' ),
										'title_help' => esc_html__( 'Check to add ajax live filter for Order by.', 'bookify-pro' ),
										'dependency' => array( 'bop_layout_preset', '!=', 'filter_layout', true ),
									),
									array(
										'id'         => 'orderby_ajax_filter_options',
										'type'       => 'fieldset',
										'title'      => esc_html__( 'Ajax Live Filters', 'bookify-pro' ),
										'fields'     => array(
											array(
												'id'      => 'orderby_filter_style',
												'type'    => 'select',
												'title'   => esc_html__( 'Filter Type', 'bookify-pro' ),
												'title_help' => esc_html__( 'Select a type for live filter.', 'bookify-pro' ),
												'options' => array(
													'fl_dropdown' => esc_html__( 'Dropdown', 'bookify-pro' ),
													'fl_radio'    => esc_html__( 'Radio', 'bookify-pro' ),
													'fl_btn'      => esc_html__( 'Button', 'bookify-pro' ),
												),
												'default' => 'fl_dropdown',
											),
											array(
												'id'      => 'bop_orderby_filter_btn_color',
												'type'    => 'color_group',
												'title'   => esc_html__( 'Button Color', 'bookify-pro' ),
												'dependency' => array( 'orderby_filter_style', '==', 'fl_btn' ),
												'options' => array(
													'text_color'        => esc_html__( 'Text Color', 'bookify-pro' ),
													'text_acolor'       => esc_html__( 'Text Hover', 'bookify-pro' ),
													'border_color'      => esc_html__( 'Border Color', 'bookify-pro' ),
													'border_acolor'     => esc_html__( 'Border Hover', 'bookify-pro' ),
													'background'        => esc_html__( 'Background', 'bookify-pro' ),
													'active_background' => esc_html__( 'Active/Hover BG', 'bookify-pro' ),
												),
												'default' => array(
													'text_color'        => '#5e5e5e',
													'text_acolor'       => '#ffffff',
													'border_color'      => '#bbbbbb',
													'border_acolor'     => '#c27b7f',
													'background'        => '#ffffff',
													'active_background' => '#c27b7f',
												),
											),
											array(
												'id'       => 'order_margin_between_button',
												'type'     => 'spacing',
												'title'    => esc_html__( 'Margin Between Buttons', 'bookify-pro' ),
												'sanitize' => 'bop_sanitize_number_array_field',
												'subtitle' => esc_html__( 'Set margin between buttons.', 'bookify-pro' ),
												'units'    => array( 'px' ),
												'default'  => array(
													'top'  => '0',
													'right' => '8',
													'bottom' => '8',
													'left' => '0',
													'unit' => 'px',
												),
												'dependency' => array( 'orderby_filter_style', '==', 'fl_btn' ),
											),
											array(
												'id'       => 'bop_add_filter_orderby',
												'type'     => 'select',
												'title'    => esc_html__( 'Order by', 'bookify-pro' ),
												'title_help' => esc_html__( 'Choose order by options to show to the visitors.', 'bookify-pro' ),
												'chosen'   => true,
												'multiple' => true,
												'sortable' => true,
												'options'  => array(
													'ID'   => esc_html__( 'ID', 'bookify-pro' ),
													'title' => esc_html__( 'Title', 'bookify-pro' ),
													'date' => esc_html__( 'Date', 'bookify-pro' ),
													'modified' => esc_html__( 'Modified date', 'bookify-pro' ),
													'post_type' => esc_html__( 'Post type', 'bookify-pro' ),
													'rand' => esc_html__( 'Random', 'bookify-pro' ),
													'menu_order' => esc_html__( 'Menu order', 'bookify-pro' ),
													'author' => esc_html__( 'Author', 'bookify-pro' ),
													'most_liked' => esc_html__( 'Most Liked', 'bookify-pro' ),
													'most_viewed' => esc_html__( 'Most Viewed', 'bookify-pro' ),
												),
											),
											array(
												'id'      => 'ajax_filter_label',
												'type'    => 'text',
												'title'   => esc_html__( 'Label', 'bookify-pro' ),
												'title_help' => esc_html__( 'Type live filter label.', 'bookify-pro' ),
												'default' => esc_html__( 'Order by', 'bookify-pro' ),
											),
											array(
												'id'      => 'bop_live_filter_align',
												'type'    => 'button_set',
												'title'   => esc_html__( 'Alignment', 'bookify-pro' ),
												'options' => array(
													'left' => wp_kses( __( '<i class="fas fa-align-left" title="Left"></i>', 'bookify-pro' ), array( 'i' => array( 'class' => array() ) ) ),
													'center' => wp_kses( __( '<i class="fas fa-align-center" title="Center"></i>', 'bookify-pro' ), array( 'i' => array( 'class' => array() ) ) ),
													'right' => wp_kses( __( '<i class="fas fa-align-right" title="Right"></i>', 'bookify-pro' ), array( 'i' => array( 'class' => array() ) ) ),
												),
												'default' => 'center',
											),
										),
										'dependency' => array( 'add_orderby_filter_post', '==', 'true' ),
									),
									array(
										'id'         => 'bop_select_filter_order',
										'type'       => 'select',
										'title'      => esc_html__( 'Order', 'bookify-pro' ),
										'options'    => array(
											'ASC'  		=> esc_html__( 'Ascending', 'bookify-pro' ),
											'DESC' 		=> esc_html__( 'Descending', 'bookify-pro' ),
										),
										'default'    => 'DESC',
										'dependency' => array( 'bop_select_filter_orderby', '!=', 'post__in' ),
									),
									array(
										'id'         => 'add_order_filter_post',
										'type'       => 'checkbox',
										'title'      => esc_html__( 'Add to Ajax Live Filters', 'bookify-pro' ),
										'title_help' => esc_html__( 'Check to add ajax live filter for order.', 'bookify-pro' ),
										'dependency' => array( 'bop_select_filter_orderby|bop_layout_preset', '!=|!=', 'post__in|filter_layout', true ),
									),
									array(
										'id'         => 'order_filter_options',
										'type'       => 'fieldset',
										'title'      => esc_html__( 'Ajax Live Filters', 'bookify-pro' ),
										'dependency' => array( 'add_order_filter_post|bop_select_filter_orderby', '==|!=', 'true|post__in', true ),
										'fields'     => array(
											array(
												'id'      => 'order_filter_style',
												'type'    => 'select',
												'title'   => esc_html__( 'Filter Type', 'bookify-pro' ),
												'title_help' => esc_html__( 'Select a type for live filter.', 'bookify-pro' ),
												'options' => array(
													'fl_dropdown' => esc_html__( 'Dropdown', 'bookify-pro' ),
													'fl_radio'    => esc_html__( 'Radio', 'bookify-pro' ),
													'fl_btn'      => esc_html__( 'Button', 'bookify-pro' ),
												),
												'default' => 'fl_btn',
											),
											array(
												'id'      => 'bop_order_filter_button_color',
												'type'    => 'color_group',
												'title'   => esc_html__( 'Button Color', 'bookify-pro' ),
												'dependency' => array( 'order_filter_style', '==', 'fl_btn' ),
												'options' => array(
													'text_color'        => esc_html__( 'Text Color', 'bookify-pro' ),
													'text_acolor'       => esc_html__( 'Text Hover', 'bookify-pro' ),
													'border_color'      => esc_html__( 'Border Color', 'bookify-pro' ),
													'border_acolor'     => esc_html__( 'Border Hover', 'bookify-pro' ),
													'background'        => esc_html__( 'Background', 'bookify-pro' ),
													'active_background' => esc_html__( 'Active/Hover BG', 'bookify-pro' ),
												),
												'default' => array(
													'text_color'        => '#5e5e5e',
													'text_acolor'       => '#ffffff',
													'border_color'      => '#bbbbbb',
													'border_acolor'     => '#c27b7f',
													'background'        => '#ffffff',
													'active_background' => '#c27b7f',
												),
											),
											array(
												'id'      => 'order_filter_label',
												'type'    => 'text',
												'title'   => esc_html__( 'Label', 'bookify-pro' ),
												'title_help' => esc_html__( 'Type live filter label.', 'bookify-pro' ),
												'default' => esc_html__( 'Order', 'bookify-pro' ),
											),
											array(
												'id'      => 'bop_live_filter_align',
												'type'    => 'button_set',
												'title'   => esc_html__( 'Alignment', 'bookify-pro' ),
												'options' => array(
													'left' => wp_kses( __( '<i class="fas fa-align-left" title="Left"></i>', 'bookify-pro' ), array( 'i' => array( 'class' => array() ) ) ),
													'center' => wp_kses( __( '<i class="fas fa-align-center" title="Center"></i>', 'bookify-pro' ), array( 'i' => array( 'class' => array() ) ) ),
													'right' => wp_kses( __( '<i class="fas fa-align-right" title="Right"></i>', 'bookify-pro' ), array( 'i' => array( 'class' => array() ) ) ),
												),
												'default' => 'center',
											),

										),
									),
								),
							),
						),
						'dependency' => array( 'bop_advanced_filter', 'not-any', 'taxonomy,author,custom_field,status,date,keyword' ),
					),
					array(
						'id'         => 'bop_filter_custom_field',
						'type'       => 'accordion',
						'class'      => 'padding-t-0 bop-opened-accordion',
						'accordions' => array(
							array(
								'title'  => esc_html__( 'Custom Fields', 'bookify-pro' ),
								'icon'   => 'fas fa-th-list',
								'fields' => array(
									// The Group Fields.
									array(
										'id'     => 'bop_filter_by_custom_field_group',
										'type'   => 'group',
										'class'  => 'bop_filter_custom_field_group bop_custom_group_design',
										'accordion_title_auto' => true,
										'fields' => array(
											array(
												'id'      => 'bop_select_custom_field_key',
												'type'    => 'select',
												'title'   => esc_html__( 'Custom Fields Keys', 'bookify-pro' ),
												'title_help' => esc_html__( 'Select custom fields key.', 'bookify-pro' ),
												'options' => 'custom_fields',
												'chosen'  => true,
												'attributes' => array(
													'style' => 'width: 200px;',
												),
												'empty_message' => esc_html__( 'No custom field keys found.', 'bookify-pro' ),
											),
											array(
												'id'      => 'bop_select_custom_field_value_type',
												'type'    => 'select',
												'title'   => esc_html__( 'Value Type', 'bookify-pro' ),
												'title_help' => esc_html__( 'Select a value type.', 'bookify-pro' ),
												'options' => array(
													'CHAR' => esc_html__( 'Text', 'bookify-pro' ),
													'NUMERIC' => esc_html__( 'Number', 'bookify-pro' ),
													'DATE' => esc_html__( 'Date', 'bookify-pro' ),
													'BOOLEAN' => esc_html__( 'True/False', 'bookify-pro' ),
												),
												'default' => 'text',
											),
											array(
												'id'      => 'bop_select_custom_compare_operator_text',
												'type'    => 'select',
												'title'   => esc_html__( 'Compare Operator', 'bookify-pro' ),
												'title_help' => esc_html__( 'Select compare operator.', 'bookify-pro' ),
												'options' => array(
													'='    => esc_html__( 'Equal (=)', 'bookify-pro' ),
													'!='   => esc_html__( 'Not Equal (!=)', 'bookify-pro' ),
													'LIKE' => esc_html__( 'Like', 'bookify-pro' ),
													'NOT LIKE' => esc_html__( 'Not Like', 'bookify-pro' ),
													'IN'   => esc_html__( 'In', 'bookify-pro' ),
													'NOT IN' => esc_html__( 'Not In', 'bookify-pro' ),
													'EXISTS' => esc_html__( 'Exists', 'bookify-pro' ),
													'NOT EXISTS' => esc_html__( 'Not Exists', 'bookify-pro' ),
												),
												'default' => 'text',
												'dependency' => array( 'bop_select_custom_field_value_type|add_filter_post', '==|!=', 'CHAR|true' ),
											),
											array(
												'id'      => 'bop_select_custom_compare_operator_number',
												'type'    => 'select',
												'title'   => esc_html__( 'Compare Operator', 'bookify-pro' ),
												'title_help' => esc_html__( 'Select compare operator.', 'bookify-pro' ),
												'options' => array(
													'='  => esc_html__( 'Equal (=)', 'bookify-pro' ),
													'!=' => esc_html__( 'Not Equal (!=)', 'bookify-pro' ),
													'>'  => esc_html__( 'Greater (>)', 'bookify-pro' ),
													'>=' => esc_html__( 'Greater or Equal (>=)', 'bookify-pro' ),
													'<'  => esc_html__( 'Less (<)', 'bookify-pro' ),
													'<=' => esc_html__( 'Less or Equal (<=)', 'bookify-pro' ),
													'IN' => esc_html__( 'In', 'bookify-pro' ),
													'NOT IN' => esc_html__( 'Not In', 'bookify-pro' ),
													'BETWEEN' => esc_html__( 'Between', 'bookify-pro' ),
													'NOT BETWEEN' => esc_html__( 'Not Between', 'bookify-pro' ),
													'EXISTS' => esc_html__( 'Exists', 'bookify-pro' ),
													'NOT EXISTS' => esc_html__( 'Not Exists', 'bookify-pro' ),
												),
												'default' => '=',
												'dependency' => array( 'bop_select_custom_field_value_type|add_filter_post', '==|!=', 'NUMERIC|true' ),
											),
											array(
												'id'      => 'bop_select_custom_compare_operator_date',
												'type'    => 'select',
												'title'   => esc_html__( 'Compare Operator', 'bookify-pro' ),
												'title_help' => esc_html__( 'Select compare operator.', 'bookify-pro' ),
												'options' => array(
													'TODAY' => esc_html__( 'Today', 'bookify-pro' ),
													'NOW_PAST' => esc_html__( 'Now and Past', 'bookify-pro' ),
													'NOW_FUTURE' => esc_html__( 'Now and Future', 'bookify-pro' ),
													'IN_PAST' => esc_html__( 'In the past', 'bookify-pro' ),
													'='  => esc_html__( 'Equal(=)', 'bookify-pro' ),
													'!=' => esc_html__( 'Not Equal(!=)', 'bookify-pro' ),
													'>'  => esc_html__( 'Greater(>)', 'bookify-pro' ),
													'>=' => esc_html__( 'Greater or Equel (>=)', 'bookify-pro' ),
													'<'  => esc_html__( 'Less (<)', 'bookify-pro' ),
													'<=' => esc_html__( 'Less or Equal (<=)', 'bookify-pro' ),
													'BETWEEN' => esc_html__( 'Between', 'bookify-pro' ),
													'NOT BETWEEN' => esc_html__( 'Not Between', 'bookify-pro' ),
													'EXISTS' => esc_html__( 'Exists', 'bookify-pro' ),
													'NOT EXISTS' => esc_html__( 'Not Exists', 'bookify-pro' ),
												),
												'default' => '=',
												'dependency' => array( 'bop_select_custom_field_value_type|add_filter_post', '==|!=', 'DATE|true' ),
											),
											array(
												'id'      => 'bop_select_custom_compare_operator_boolean',
												'type'    => 'select',
												'title'   => esc_html__( 'Compare Operator', 'bookify-pro' ),
												'title_help' => esc_html__( 'Select compare operator.', 'bookify-pro' ),
												'options' => array(
													'='  => esc_html__( 'Equal(=)', 'bookify-pro' ),
													'!=' => esc_html__( 'Not Equal(!=)', 'bookify-pro' ),
													'EXISTS' => esc_html__( 'Exists', 'bookify-pro' ),
													'NOT EXISTS' => esc_html__( 'Not Exists', 'bookify-pro' ),
												),
												'default' => '=',
												'dependency' => array( 'bop_select_custom_field_value_type|add_filter_post', '==|!=', 'BOOLEAN|true' ),
											),
											array(
												'id'    => 'bop_select_custom_field_text_value',
												'type'  => 'text',
												'title' => esc_html__( 'Compare Value', 'bookify-pro' ),
												'title_help' => esc_html__( 'Type compare value.', 'bookify-pro' ),
												'dependency' => array( 'bop_select_custom_field_value_type|add_filter_post', 'any|!=', 'CHAR,NUMERIC|true' ),
											),
											array(
												'id'       => 'bop_select_custom_field_date_value_from_to',
												'type'     => 'date',
												'title'    => esc_html__( 'Compare Value', 'bookify-pro' ),
												'title_help' => esc_html__( 'Type compare value.', 'bookify-pro' ),
												'settings' => array(
													'dateFormat' => 'yy-mm-dd',
												),
												'from_to'  => true,
												'text_from' => 'From',
												'text_to'  => 'To',
												'placeholder' => esc_html__( 'yy-mm-dd', 'bookify-pro' ),
												'dependency' => array( 'bop_select_custom_field_value_type|bop_select_custom_compare_operator_date|add_filter_post', '==|any|!=', 'DATE|BETWEEN,NOT BETWEEN,EXISTS,NOT EXISTS|true' ),
											),
											array(
												'id'       => 'bop_select_custom_field_date_value',
												'type'     => 'date',
												'title'    => esc_html__( 'Compare Value', 'bookify-pro' ),
												'title_help' => esc_html__( 'Type compare value.', 'bookify-pro' ),
												'settings' => array(
													'dateFormat' => 'yy-mm-dd',
												),
												'placeholder' => esc_html__( 'yy-mm-dd', 'bookify-pro' ),
												'dependency' => array( 'bop_select_custom_field_value_type|bop_select_custom_compare_operator_date|add_filter_post', '==|not-any|!=', 'DATE|BETWEEN,NOT BETWEEN,EXISTS,NOT EXISTS|true' ),
											),
											array(
												'id'      => 'bop_select_custom_field_boolean_value',
												'type'    => 'select',
												'title'   => esc_html__( 'Compare Value', 'bookify-pro' ),
												'title_help' => esc_html__( 'Type compare value.', 'bookify-pro' ),
												'options' => array(
													'1' => esc_html__( 'True', 'bookify-pro' ),
													'0' => esc_html__( 'False', 'bookify-pro' ),
												),
												'dependency' => array( 'bop_select_custom_field_value_type|add_filter_post', '==|!=', 'BOOLEAN|true' ),
											),
											array(
												'id'    => 'add_filter_post',
												'type'  => 'checkbox',
												'title' => esc_html__( 'Add to Ajax Live Filters', 'bookify-pro' ),
												'title_help' => esc_html__( 'Check to add ajax live filters.', 'bookify-pro' ),
											),
											array(
												'id'     => 'ajax_filter_options',
												'type'   => 'fieldset',
												'title'  => esc_html__( 'Ajax Live Filters', 'bookify-pro' ),
												'dependency' => array( 'add_filter_post', '==', 'true' ),
												'fields' => array(
													array(
														'id'       => 'ajax_filter_style',
														'type'     => 'select',
														'title'    => esc_html__( 'Filter Type', 'bookify-pro' ),
														'title_help' => esc_html__( 'Select a type for live filter.', 'bookify-pro' ),
														'options'  => array(
															'fl_dropdown' => esc_html__( 'Dropdown', 'bookify-pro' ),
															'fl_radio'    => esc_html__( 'Radio', 'bookify-pro' ),
															'fl_checkbox'      => esc_html__( 'Checkbox', 'bookify-pro' ),
															'fl_btn'      => esc_html__( 'Button', 'bookify-pro' ),
															'fl_slider'      => esc_html__( 'Ranger Slider (number only)', 'bookify-pro' ),
														),
														'default'  => 'fl_btn',
													),
													array(
														'id'       => 'bop_filter_btn_color',
														'type'     => 'color_group',
														'title'    => esc_html__( 'Button Color', 'bookify-pro' ),
														'dependency' => array( 'ajax_filter_style', '==', 'fl_btn' ),
														'options'  => array(
															'text_color'        => esc_html__( 'Text Color', 'bookify-pro' ),
															'text_acolor'       => esc_html__( 'Text Hover', 'bookify-pro' ),
															'border_color'      => esc_html__( 'Border Color', 'bookify-pro' ),
															'border_acolor'     => esc_html__( 'Border Hover', 'bookify-pro' ),
															'background'        => esc_html__( 'Background', 'bookify-pro' ),
															'active_background' => esc_html__( 'Active/Hover BG', 'bookify-pro' ),
														),
														'default'  => array(
															'text_color'        => '#5e5e5e',
															'text_acolor'       => '#ffffff',
															'border_color'      => '#bbbbbb',
															'border_acolor'     => '#c27b7f',
															'background'        => '#ffffff',
															'active_background' => '#c27b7f',
														),
													),
													array(
														'id'       => 'ajax_filter_label',
														'type'     => 'text',
														'title'    => esc_html__( 'Label', 'bookify-pro' ),
														'title_help' => esc_html__( 'Type live filter label.', 'bookify-pro' ),
													),
													array(
														'id'       => 'ajax_rename_all_text',
														'type'     => 'text',
														'title'    => esc_html__( 'Rename "All" Text', 'bookify-pro' ),
														'title_help' => esc_html__( 'Leave it empty to hide "All" text.', 'bookify-pro' ),
														'default'  => esc_html__( 'All', 'bookify-pro' ),
														'dependency' => array( 'ajax_filter_style', 'not-any', 'fl_checkbox,fl_slider' ),
													),
													array(
														'id'       => 'ajax_hide_empty',
														'type'     => 'checkbox',
														'title'    => esc_html__( 'Hide Empty Term(s)', 'bookify-pro' ),
														'title_help' => esc_html__( 'Check to hide empty terms.', 'bookify-pro' ),
														'dependency' => array( 'ajax_filter_style', '!=', 'fl_slider' ),
													),
													array(
														'id'       => 'ajax_show_count',
														'type'     => 'checkbox',
														'title'    => esc_html__( 'Show Post Count', 'bookify-pro' ),
														'title_help' => esc_html__( 'Check to show post count.', 'bookify-pro' ),
														'default'  => false,
														'dependency' => array( 'ajax_filter_style', '!=', 'fl_slider' ),
													),
													array(
														'id'       => 'bop_live_filter_align',
														'type'     => 'button_set',
														'title'    => esc_html__( 'Alignment', 'bookify-pro' ),
														'options'    => array(
															'left'   => wp_kses( __( '<i class="fas fa-align-left" title="Left"></i>', 'bookify-pro' ), array( 'i' => array( 'class' => array() ) ) ),
															'center' => wp_kses( __( '<i class="fas fa-align-center" title="Center"></i>', 'bookify-pro' ), array( 'i' => array( 'class' => array() ) ) ),
															'right'  => wp_kses( __( '<i class="fas fa-align-right" title="Right"></i>', 'bookify-pro' ), array( 'i' => array( 'class' => array() ) ) ),
														),
														'default'  => 'center',
													),
												),
											),
										),
									), // Group field end.
									array(
										'id'         => 'bop_filter_custom_field_relation',
										'type'       => 'select',
										'title'      => esc_html__( 'Relation', 'bookify-pro' ),
										'class'      => 'bop_relate_among_taxonomies',
										'options'    => array(
											'AND' => esc_html__( 'AND', 'bookify-pro' ),
											'OR'  => esc_html__( 'OR', 'bookify-pro' ),
										),
										'default'    => 'OR',
										'title_help' => esc_html__( 'The logical relationship between/among above custom fields.', 'bookify-pro' ),
									),
								),
							),
						),
						'dependency' => array( 'bop_advanced_filter', 'not-any', 'taxonomy,author,sortby,status,date,keyword' ),
					),
					array(
						'id'         => 'bop_filter_by_status',
						'type'       => 'accordion',
						'class'      => 'padding-t-0 bop-opened-accordion',
						'accordions' => array(
							array(
								'title'  => esc_html__( 'Status', 'bookify-pro' ),
								'icon'   => 'fas fa-lock',
								'fields' => array(
									array(
										'id'       => 'bop_select_post_status',
										'type'     => 'select',
										'title'    => esc_html__( 'Post Status', 'bookify-pro' ),
										'options'  => 'post_statuses',
										'multiple' => true,
										'chosen'   => true,
									),
								),
							),
						),
						'dependency' => array( 'bop_advanced_filter', 'not-any', 'taxonomy,author,custom_field,sortby,date,keyword' ),
					),
					array(
						'id'         => 'bop_filter_by_date',
						'type'       => 'accordion',
						'class'      => 'padding-t-0 bop-opened-accordion',
						'accordions' => array(
							array(
								'title'  => esc_html__( 'Published Date', 'bookify-pro' ),
								'icon'   => 'fas fa-calendar',
								'fields' => array(
									array(
										'id'      => 'bop_select_post_date_type',
										'type'    => 'radio',
										'class'   => 'bop_column_2',
										'options' => array(
											'yesterday'  => esc_html__( 'Yesterday', 'bookify-pro' ),
											'today_only' => esc_html__( 'Today Only', 'bookify-pro' ),
											'today_onwards' => esc_html__( 'Today and Onwards', 'bookify-pro' ),
											'this_week'  => esc_html__( 'This Week', 'bookify-pro' ),
											'this_month' => esc_html__( 'This Month', 'bookify-pro' ),
											'this_year'  => esc_html__( 'This Year', 'bookify-pro' ),
											'week_ago'   => esc_html__( '1 Week ago to today', 'bookify-pro' ),
											'month_ago'  => esc_html__( '1 month ago to today', 'bookify-pro' ),
											'year_ago'   => esc_html__( '1 year ago to today', 'bookify-pro' ),
											'specific_date' => esc_html__( 'Specific Date', 'bookify-pro' ),
											'specific_month' => esc_html__( 'Specific Month', 'bookify-pro' ),
											'specific_year' => esc_html__( 'Specific Year', 'bookify-pro' ),
											'specific_period' => esc_html__( 'Specific Period ( From & To )', 'bookify-pro' ),
										),
										'default' => 'today_only',
									),
									array(
										'id'          => 'bop_select_post_date_from_to',
										'type'        => 'date',
										'title'       => esc_html__( 'Set Period', 'bookify-pro' ),
										'from_to'     => true,
										'text_from'   => esc_html__( 'From:', 'bookify-pro' ),
										'text_to'     => esc_html__( 'To:', 'bookify-pro' ),
										'settings'    => array(
											'dateFormat'  => 'yy-mm-dd',
											'changeMonth' => true,
											'changeYear'  => true,
										),
										'placeholder' => esc_html__( 'yy-mm-dd', 'bookify-pro' ),
										'dependency'  => array( 'bop_select_post_date_type', '==', 'specific_period' ),
									),
									array(
										'id'          => 'bop_select_post_specific_date',
										'type'        => 'date',
										'title'       => esc_html__( 'Select Date', 'bookify-pro' ),
										'settings'    => array(
											'dateFormat'  => 'yy-mm-dd',
											'changeMonth' => true,
											'changeYear'  => true,
										),
										'placeholder' => esc_html__( 'yy-mm-dd', 'bookify-pro' ),
										'dependency'  => array( 'bop_select_post_date_type', '==', 'specific_date' ),
									),
									array(
										'id'         => 'bop_select_specific_month',
										'type'       => 'select',
										'title'      => esc_html__( 'Select Month', 'bookify-pro' ),
										'options'    => array(
											'1'  => esc_html__( 'January', 'bookify-pro' ),
											'2'  => esc_html__( 'February', 'bookify-pro' ),
											'3'  => esc_html__( 'March', 'bookify-pro' ),
											'4'  => esc_html__( 'April', 'bookify-pro' ),
											'0'  => esc_html__( 'May', 'bookify-pro' ),
											'6'  => esc_html__( 'June', 'bookify-pro' ),
											'7'  => esc_html__( 'July', 'bookify-pro' ),
											'8'  => esc_html__( 'August', 'bookify-pro' ),
											'9'  => esc_html__( 'September', 'bookify-pro' ),
											'10' => esc_html__( 'October', 'bookify-pro' ),
											'11' => esc_html__( 'November', 'bookify-pro' ),
											'12' => esc_html__( 'December', 'bookify-pro' ),
										),
										'dependency' => array( 'bop_select_post_date_type', '==', 'specific_month' ),
									),
									array(
										'id'              => 'bop_select_post_specific_year',
										'type'            => 'spacing',
										'title'           => esc_html__( 'Set Year', 'bookify-pro' ),
										'sanitize'        => 'bop_sanitize_number_array_field',
										'all'             => true,
										'all_icon'        => false,
										'all_placeholder' => esc_html__('2019', 'bookify-pro'),
										'show_units'      => false,
										'default'         => array(
											'all' => esc_html__('2019', 'bookify-pro'),
										),
										'min'             => '1990',
										'dependency'      => array( 'bop_select_post_date_type', '==', 'specific_year' ),
									),
								), // Fields.
							),
						), // Accordions.
						'dependency' => array( 'bop_advanced_filter', 'not-any', 'taxonomy,author,custom_field,sortby,status,keyword' ),
					),
					array(
						'id'         => 'bop_filter_by_keyword',
						'type'       => 'accordion',
						'class'      => 'padding-t-0 bop-opened-accordion',
						'accordions' => array(
							array(
								'title'  => esc_html__( 'Keyword', 'bookify-pro' ),
								'icon'   => 'fas fa-key',
								'fields' => array(
									array(
										'id'         => 'bop_set_post_keyword',
										'type'       => 'text',
										'title'      => esc_html__( 'Type Keyword', 'bookify-pro' ),
										'title_help' => esc_html__( 'Enter keyword(s) for searching the posts.', 'bookify-pro' ),
										'options'    => 'post_statuses',
									),
									array(
										'id'         => 'add_search_filter_post',
										'type'       => 'checkbox',
										'title'      => esc_html__( 'Add to Ajax Live Filters', 'bookify-pro' ),
										'title_help' => esc_html__( 'Check to add ajax live filter.', 'bookify-pro' ),
										'dependency' => array( 'bop_layout_preset', '!=', 'filter_layout', true ),
									),
									array(
										'id'         => 'ajax_filter_options',
										'type'       => 'fieldset',
										'title'      => esc_html__( 'Ajax Live Filters', 'bookify-pro' ),
										'dependency' => array( 'add_search_filter_post', '==', 'true', true ),
										'fields'     => array(
											array(
												'id'    => 'ajax_filter_label',
												'type'  => 'text',
												'title' => esc_html__( 'Label', 'bookify-pro' ),
												'title_help' => esc_html__( 'Type live filter label.', 'bookify-pro' ),
											),
											array(
												'id'      => 'bop_live_filter_align',
												'type'    => 'button_set',
												'title'   => esc_html__( 'Alignment', 'bookify-pro' ),
												'options' => array(
													'left' => wp_kses( __( '<i class="fas fa-align-left" title="Left"></i>', 'bookify-pro' ), array( 'i' => array( 'class' => array() ) ) ),
													'center' => wp_kses( __( '<i class="fas fa-align-center" title="Center"></i>', 'bookify-pro' ), array( 'i' => array( 'class' => array() ) ) ),
													'right' => wp_kses( __( '<i class="fas fa-align-right" title="Right"></i>', 'bookify-pro' ), array( 'i' => array( 'class' => array() ) ) ),
												),
												'default' => 'center',
											),
										),
									),
								),
							),
						),
						'dependency' => array( 'bop_advanced_filter', 'not-any', 'taxonomy,author,custom_field,sortby,date,status' ),
					),
				),
			)
		); // Filter settings section end.
	}
}
